package org.maachang.comet.down ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * シャットダウンフック.
 *
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class ShutdownHook extends Thread {
    
    /**
     * LOG.
     */
    private static final Log LOG = LogFactory.getLog( ShutdownHook.class ) ;
    
    /**
     * シャットダウンコールバックメソッド.
     */
    private ShutdownCallback callback = null ;
    
    /**
     * コンストラクタ.
     */
    private ShutdownHook() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * シャットダウンフックを設定してオブジェクトを生成します.
     * <BR>
     * @param callback シャットダウンコールバックオブジェクトを設定します.
     */
    private ShutdownHook( ShutdownCallback callback ) {
        this.callback = callback ;
        this.setPriority( Thread.MAX_PRIORITY ) ;
        this.setDaemon( false ) ;
    }
    
    /**
     * シャットダウンフックの開始.
     * <BR><BR>
     * シャットダウンフックを開始します.
     * <BR>
     * @param callback シャットダウンコールバックオブジェクトを設定します.
     * @return ShutdownHook 生成されたシャットダウンフックオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final ShutdownHook registHook( ShutdownCallback callback )
        throws Exception {
        if( callback == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        LOG.info ( "## シャットダウンフックを登録します" ) ;
        ShutdownHook ret = new ShutdownHook( callback ) ;
        Runtime.getRuntime().addShutdownHook( ret ) ;
        return ret ;
    }
    
    /**
     * シャットダウンコールバックオブジェクトを取得.
     * <BR>
     * @return ShutdownCallback シャットダウンコールバックオブジェクトが返されます.
     */
    public ShutdownCallback getShutdownCallback() {
        return callback ;
    }
    
    /**
     * シャットダウン実行.
     * <BR><BR>
     * シャットダウン処理を実施します.
     */
    public void run() {
        if( callback.isShutdown() == false ) {
            LOG.info ( "## シャットダウンフックを開始します" ) ;
            try { callback.execution() ; } catch( Exception e ) {}
            LOG.info ( "## シャットダウンフックを終了します" ) ;
        }
    }
}
