package org.maachang.comet.httpd.engine.script.dao;

import java.util.HashMap;

import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;


/**
 * カラム用メタデータ.
 * 
 * @version 2007/08/19
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class MetaJson {
    
    /**
     * MetaColumn.
     */
    private MetaColumn column = null ;
    
    /**
     * コンストラクタ.
     */
    private MetaJson() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param column 対象のメタカラムを設定します.
     */
    public MetaJson( MetaColumn column ) {
        this.column = column ;
    }
    
    /**
     * カラムデータをjson形式に変換.
     * <BR><BR>
     * カラムデータをjson形式に変換します.
     * <BR>
     * @return HashMap<String,Object> 変換された文字列が返されます.
     */
    public HashMap<String,Object> getJson() {
        if( column == null || column.size() <= 0 ) {
            return null ;
        }
        HashMap<String,Object> ret = new HashMap<String,Object>() ;
        int len = column.size() ;
        for( int i = 0 ; i < len ; i ++ ) {
            ret.put( DbUtil.convertDBNameByJavaName( false,column.getColumnName( i ) ),null ) ;
        }
        return ret ;
    }
    
    /**
     * メタカラムオブジェクトを取得.
     * <BR><BR>
     * メタカラムオブジェクトを取得します.
     * <BR>
     * @return MetaColumn メタカラムオブジェクトが返されます.
     */
    public MetaColumn getMeta() {
        return column ;
    }
    
}
