package org.maachang.dao;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.maachang.conf.Config;
import org.maachang.dao.dbms.DbmsInfo;
import org.maachang.dao.dbms.RecordFactory;

/**
 * Dao初期化処理.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public class InitDao {
    
    /**
     * Dao初期化処理.
     * <BR><BR>
     * @param fileName 対象のファイル名を設定します.
     * @exception Exception 例外.
     */
    public static final void init( String fileName )
        throws Exception {
        init( DbmsInfo.getConfig( new FileInputStream( fileName ) ) ) ;
    }
    
    /**
     * Dao初期化処理.
     * <BR><BR>
     * @param in 対象のInputStreamを設定します.
     * @exception Exception 例外.
     */
    public static final void init( InputStream in )
        throws Exception {
        init( DbmsInfo.getConfig( in ) ) ;
    }
    
    /**
     * Dao初期化処理.
     * <BR><BR>
     * @param conf 対象のコンフィグ情報を設定します.
     * @exception Exception 例外.
     */
    public static final void init( Config config )
        throws Exception {
        RecordFactory factory = DbmsInfo.getRecordFactory( config ) ;
        if( factory == null ) {
            throw new IOException( "RecordFactoryの生成に失敗しました" ) ;
        }
        DaoSessionFactory.getInstance().setRecordFactory( factory ) ;
    }
    
    /**
     * Dao初期化処理.
     * <BR><BR>
     * @param debug 対象のデバッグモードを設定します.
     * @param adapter 対象のアダプタ名を設定します.
     * @para driver 対象のドライバー名を設定します.
     * @param url 対象のURLを設定します.
     * @param user 対象のユーザ名を設定します.
     * @param passwd 対象のパスワードを設定します.
     * @param max 対象の最大コネクション数を設定します.
     * @param autoCommit 対象のオートコミット条件を設定します.
     * @param checkSQL 対象のコネクション確認用SQL文を設定します.
     * @exception Exception 例外.
     */
    public static final void init(
        boolean debug,String adapter,String driver,String url,String user,String passwd,
        int max,boolean autoCommit,String checkSQL ) throws Exception {
        RecordFactory factory = DbmsInfo.getRecordFactory(
            debug,adapter,driver,url,user,passwd,max,autoCommit,checkSQL ) ;
        if( factory == null ) {
            throw new IOException( "RecordFactoryの生成に失敗しました" ) ;
        }
        DaoSessionFactory.getInstance().setRecordFactory( factory ) ;
    }
    
    /**
     * Dao情報破棄.
     * <BR><BR>
     * Dao情報を破棄します.
     */
    public static final void destroy() {
        RecordFactory recordFactory = DaoSessionFactory.getInstance().getRecordFactory() ;
        if( recordFactory != null ) {
            recordFactory.clear() ;
            DaoSessionFactory.getInstance().setRecordFactory( null ) ;
        }
    }
}

