package org.maachang.dao.dbms;

import java.sql.ResultSet;

/**
 * Resultユーティリティ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public class ResultUtil {

    private ResultUtil() {
    }

    /**
     * ResultSetが開始していない場合に開始する. <BR>
     * <BR>
     * ResultSetが開始していない場合は、開始します. <BR>
     * 
     * @param result
     *            対象のResultSetを設定します.
     * @exception Exception
     *                例外.
     */
    public static final boolean firsetResult(ResultSet result) throws Exception {
        if (result.getRow() == 0) {
            return result.next();
        }
        return true;
    }

    /**
     * カーソルサポート. <BR>
     * <BR>
     * カーソルがサポートされているかチェックします. <BR>
     * 
     * @param result
     *            対象のResultSetを設定します.
     * @return boolean [true]の場合、サポートされています.
     * @exception Exception
     *                例外.
     */
    public static final boolean isCursorSupport(ResultSet result) throws Exception {
        return !(result.getType() == ResultSet.TYPE_FORWARD_ONLY);
    }

    /**
     * オフセット位置に移動. <BR>
     * <BR>
     * ResultSetをオフセット位置まで移動させます. <BR>
     * 
     * @param result
     *            対象のResultSetを設定します.
     * @param offset
     *            対象のオフセット値を設定します.
     * @return int オフセットされた件数が返されます.
     * @exception Exception
     *                例外.
     */
    public static final int setPosition(ResultSet result, int offset)
            throws Exception {
        int ret = 0;
        if (isCursorSupport(result) == true) {
            try {
                if (result.getRow() != offset) {
                    result.absolute(offset);
                    ret = result.getRow();
                }
            } catch( Exception ee ) {
                ret = setOldPosition(result, offset);
            }
        } else {
            ret = setOldPosition(result, offset);
        }
        return ret;
    }

    /**
     * オフセット位置を最後に設定. <BR>
     * <BR>
     * オフセット位置を最後に設定します. <BR>
     * 
     * @param result
     *            対象のResultSetを設定します.
     * @exception Exception
     *                例外.
     */
    public static final void setLast(ResultSet result) throws Exception {
        if (isCursorSupport(result) == true) {
            result.last();
        } else {
            while (result.next()) {
            }
        }
    }

    /**
     * カーソル非サポート時のオフセット遷移.
     */
    private static final int setOldPosition(ResultSet result, int offset)
            throws Exception {
        int ret = 0;
        while (ret < offset && result.next()) {
        //while (result.getRow() < offset && result.next()) {
            ret++;
        }
        return ret;
    }
}
