package org.maachang.manager ;

import java.util.HashMap;
import java.util.Hashtable;

/**
 * ThreadLocal管理.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class LocalManager {
    
    /**
     * ローカル情報管理.
     */
    private Hashtable<String, HashMap<String, Object>> params =
        new Hashtable<String, HashMap<String, Object>>();
    
    /**
     * コンストラクタ.
     */
    private LocalManager() {
    }
    
    /**
     * シングルトン.
     */
    private static final LocalManager SNGL = new LocalManager();
    
    /**
     * シングルトンを取得.
     * <BR><BR>
     * シングルトンオブジェクトを取得します.
     * <BR>
     * @return LocalManager スレッドローカル情報が返されます.
     */
    public static final LocalManager getInstance() {
        return SNGL;
    }
    
    /**
     * ローカルスレッド名を取得.
     */
    private String getLocalName() {
        return Thread.currentThread().getName();
    }
    
    /**
     * 現在のスレッド情報内容をクリア.
     * <BR><BR>
     * 現在のスレッド情報内容をクリアします.
     */
    public void clear() {
        params.get(getLocalName());
    }
    
    /**
     * ローカルスレッド情報に追加.
     * <BR><BR>
     * ローカルスレッド情報に追加します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param val 対象の要素を設定します.
     */
    public void put(String key, Object val) {
        String t = getLocalName() ;
        HashMap<String, Object> o = params.get(t);
        if (o == null) {
            o = new HashMap<String, Object>();
            params.put(t, o);
        }
        o.put(key, val);
    }
    
    /**
     * ローカルスレッド情報を取得.
     * <BR><BR>
     * ローカルスレッド情報を取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return Object 対象の要素が返されます.
     */
    public Object get(String key) {
        HashMap<String, Object> o = params.get(getLocalName());
        if (o == null) {
            return null;
        }
        return o.get(key);
    }
}
