/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmImpl;
import org.maachang.dbm.MDbmOp;
import org.maachang.dbm.MDbmOpImpl;
import org.maachang.dbm.MDbmTransaction;
import org.maachang.dbm.service.MDbmServer;
import org.maachang.util.FileUtil;
import org.maachang.util.conf.Config;
import org.maachang.util.conf.ReadIni;

public class MDbmManager {
    public static final int MIN = 0;
    public static final int MID = 1;
    public static final int MAX = 2;
    private MDbmImpl impl = null;
    private MDbmServer server = null;
    private int mode = 1;
    private static final MDbmManager SNGL = new MDbmManager();
    private static final String OPT = "mdbm-opt";

    private MDbmManager() {
    }

    public static final MDbmManager getInstance() {
        return SNGL;
    }

    public synchronized int getMode() {
        return this.mode;
    }

    public synchronized void open(String directory) throws Exception {
        if (this.impl == null) {
            this.readMDbmOpt();
            this.impl = new MDbmImpl(directory);
        }
    }

    public synchronized void close() {
        if (this.server != null) {
            this.server.destroy();
        }
        this.server = null;
        if (this.impl != null) {
            this.impl.destroy();
        }
        this.impl = null;
    }

    public synchronized void flush() throws Exception {
        if (this.impl != null) {
            this.impl.flush();
        }
    }

    public synchronized MDbm getMDbm() {
        return this.getMDbm(false);
    }

    public synchronized MDbm getMDbm(boolean mode) {
        if (this.impl != null) {
            if (mode) {
                return new MDbmTransaction(this.impl);
            }
            return this.impl;
        }
        return null;
    }

    public synchronized MDbmOp getMDbmOp() {
        return this.getMDbmOp(false);
    }

    public synchronized MDbmOp getMDbmOp(boolean mode) {
        if (this.impl != null) {
            if (mode) {
                return new MDbmOpImpl(new MDbmTransaction(this.impl));
            }
            return new MDbmOpImpl(this.impl);
        }
        return null;
    }

    public synchronized boolean isClose() {
        return this.impl == null;
    }

    public synchronized String getDirectory() {
        if (this.impl != null) {
            return this.impl.getDirectory();
        }
        return null;
    }

    public synchronized int size() {
        if (this.impl != null) {
            return this.impl.size();
        }
        return -1;
    }

    public synchronized int sectorFile() {
        if (this.impl != null) {
            return this.impl.sectorFile();
        }
        return -1;
    }

    public synchronized int useSector() {
        if (this.impl != null) {
            return this.impl.useSector();
        }
        return -1;
    }

    public synchronized int maxSector() {
        if (this.impl != null) {
            return this.impl.maxSector();
        }
        return -1;
    }

    public synchronized long freeSpace() {
        if (this.impl != null) {
            return this.impl.freeSpace();
        }
        return -1L;
    }

    public synchronized void setServer(MDbmServer server) {
        this.server = server;
    }

    public synchronized MDbmServer getServer() {
        return this.server;
    }

    private void setMode(int mode) throws IOException {
        if (this.impl != null) {
            throw new IOException("\u8d77\u52d5\u5f8c\u306b\u8a2d\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        switch (mode) {
            case 0: {
                this.mode = mode;
                System.getProperty("mdbm.hash", String.valueOf(18));
                System.getProperty("mdbm.key", String.valueOf(128));
                System.getProperty("mdbm.sector", String.valueOf(512));
                System.getProperty("mdbm.maxLength", String.valueOf(500000));
                break;
            }
            case 1: {
                this.mode = mode;
                System.getProperty("mdbm.hash", String.valueOf(20));
                System.getProperty("mdbm.key", String.valueOf(256));
                System.getProperty("mdbm.sector", String.valueOf(1024));
                System.getProperty("mdbm.maxLength", String.valueOf(15000000));
                break;
            }
            case 2: {
                this.mode = mode;
                System.getProperty("mdbm.hash", String.valueOf(26));
                System.getProperty("mdbm.key", String.valueOf(1024));
                System.getProperty("mdbm.sector", String.valueOf(8192));
                System.getProperty("mdbm.maxLength", String.valueOf(50000000));
            }
        }
    }

    private boolean readMDbmOpt() throws Exception {
        BufferedReader br;
        block23: {
            if (this.impl != null) {
                throw new IOException("\u8d77\u52d5\u5f8c\u306b\u8a2d\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            if (!FileUtil.isFileExists("./conf/mdbm.conf")) {
                return false;
            }
            br = null;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("./conf/mdbm.conf"), "UTF8"));
            Config conf = new Config();
            ReadIni.analisys(conf, br);
            br.close();
            br = null;
            if (!conf.isSection(OPT)) {
                return false;
            }
            int mode = 1;
            String s = conf.get(OPT, "mode", 0);
            if (s != null && (s = s.trim()).length() > 0) {
                if ("min".equals(s = s.toLowerCase())) {
                    mode = 0;
                } else if ("mid".equals(s)) {
                    mode = 1;
                } else if ("max".equals(s)) {
                    mode = 2;
                }
            }
            this.setMode(mode);
            int c = conf.getInt(OPT, "mdbm.hash", 0);
            if (c >= 0) {
                System.getProperty("mdbm.hash", String.valueOf(c));
            }
            if ((c = conf.getInt(OPT, "mdbm.key", 0)) >= 0) {
                System.getProperty("mdbm.key", String.valueOf(c));
            }
            if ((c = conf.getInt(OPT, "mdbm.sector", 0)) >= 0) {
                System.getProperty("mdbm.sector", String.valueOf(c));
            }
            if ((c = conf.getInt(OPT, "mdbm.maxLength", 0)) < 0) break block23;
            System.getProperty("mdbm.maxLength", String.valueOf(c));
        }
        return true;
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

