/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;

public class IniFile {
    private static final String CHARSET = "UTF8";
    private Config iniParams = null;

    public synchronized void open(String name) throws Exception {
        this.close();
        this.addOpen(name, "");
    }

    public synchronized void open(String name, String header) throws Exception {
        this.close();
        this.addOpen(name, header);
    }

    public synchronized void addOpen(String name) throws Exception {
        this.addOpen(name, "");
    }

    public synchronized void addOpen(String name, String header) throws Exception {
        String fullPath = FileUtil.getFullPath((String)name);
        BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullPath), CHARSET));
        try {
            try {
                if (this.iniParams == null) {
                    this.iniParams = new Config();
                }
                ReadIni.analisys((Config)this.iniParams, (String)header, (BufferedReader)buf);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }
        finally {
            try {
                buf.close();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void close() {
        this.iniParams = null;
    }

    public synchronized String[] getAll(String section, String key) {
        return this.iniParams.getAll(section, key);
    }

    public synchronized String get(String section, String key, int no) {
        return this.iniParams.get(section, key, no);
    }

    public synchronized Integer getNumber(String section, String key, int no) {
        String p = this.iniParams.get(section, key, no);
        if (p == null || p.length() <= 0) {
            return null;
        }
        Integer ret = null;
        try {
            ret = new Integer(p);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public synchronized Double getFloat(String section, String key, int no) {
        String p = this.iniParams.get(section, key, no);
        if (p == null || p.length() <= 0) {
            return null;
        }
        Double ret = null;
        try {
            ret = new Double(p);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public synchronized Boolean getBoolean(String section, String key, int no) {
        String p = this.iniParams.get(section, key, no);
        if (p == null || p.length() <= 0) {
            return null;
        }
        Boolean ret = null;
        try {
            ret = new Boolean(p);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public synchronized int size(String section, String key) {
        return this.iniParams.size(section, key);
    }

    public synchronized int size() {
        return this.iniParams.size();
    }

    public synchronized Config getIniParam() {
        return this.iniParams;
    }

    public synchronized String toString() {
        if (this.iniParams != null) {
            return this.iniParams.toString();
        }
        return "null";
    }
}

