/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;

public class MailConfig {
    private static final String READ_FILE = "conf/mail.conf";
    private static final String CHARSET = "UTF8";
    private Config iniParams = null;
    private String fileName = null;
    private long lastUpdate = -1L;

    public synchronized void open() throws Exception {
        this.open(READ_FILE);
    }

    public synchronized void open(String name) throws Exception {
        this.fileName = FileUtil.getFullPath((String)name);
        try {
            this.reload();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public synchronized void close() {
        this.iniParams = null;
        this.fileName = null;
        this.lastUpdate = -1L;
    }

    public synchronized String getSmtp(String name) {
        try {
            long tm = FileUtil.getLastTime((String)this.fileName);
            if (this.lastUpdate != tm) {
                this.reload();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.iniParams.get("smtp", name, 0);
    }

    public synchronized String getPop3(String name) {
        try {
            long tm = FileUtil.getLastTime((String)this.fileName);
            if (this.lastUpdate != tm) {
                this.reload();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.iniParams.get("pop3", name, 0);
    }

    private final void reload() throws Exception {
        BufferedReader buf = null;
        if (FileUtil.isFileExists((String)this.fileName)) {
            try {
                buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), CHARSET));
                Config iniParams = new Config();
                ReadIni.analisys((Config)iniParams, (BufferedReader)buf);
                buf.close();
                buf = null;
                long last = FileUtil.getLastTime((String)this.fileName);
                this.iniParams = iniParams;
                this.lastUpdate = last;
            }
            finally {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public String toString() {
        if (this.iniParams != null) {
            return this.iniParams.toString();
        }
        return "null";
    }
}

