/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.net.Socket;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpdExecutionManager;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.HttpdDef;
import org.maachang.comet.httpd.engine.HttpdResponseInstance;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.httpd.engine.HttpdUtil;
import org.maachang.comet.httpd.engine.ImageManagerReader;
import org.maachang.comet.httpd.engine.WriteError;
import org.maachang.comet.httpd.engine.auth.HttpdAuthBasic;
import org.maachang.comet.httpd.engine.auth.HttpdAuthDigest;
import org.maachang.comet.httpd.engine.auth.HttpdAuthElement;
import org.maachang.comet.httpd.engine.auth.HttpdAuthManager;
import org.maachang.comet.httpd.engine.auth.HttpdAuthUsers;
import org.maachang.comet.httpd.engine.script.BaseScriptException;
import org.maachang.comet.net.HttpCallbackReceive;
import org.maachang.conf.ConvIniParam;
import org.maachang.manager.GlobalManager;

class HttpdExecutionReceive
implements HttpCallbackReceive {
    private static final Log LOG = LogFactory.getLog(HttpdExecutionReceive.class);

    public void execution(HttpConnectionInfo conn, int seqId, HttpdRequest request) throws Exception {
        if (conn == null || !conn.isUse()) {
            return;
        }
        try {
            if (request == null) {
                conn.destroy();
                return;
            }
            request.setConnectionInfo(conn);
            if (LOG.isInfoEnabled()) {
                Socket soc = conn.getSocket().socket();
                LOG.info((Object)("id:" + seqId + "[" + soc.getInetAddress().getHostAddress() + ":" + soc.getPort() + "]-" + "(" + request.getMethod() + ")-url:" + request.getUrlPath() + " [" + request.getHeader().getHeader("User-Agent") + "]"));
                soc = null;
            }
            HttpdExecutionReceive.putGzip(request);
            if (!HttpdDef.isSeePath(request.getUrlPath())) {
                try {
                    WriteError.output(request, null, 403, "\u6307\u5b9aURL\u306f\u4e0d\u6b63\u3067\u3059");
                }
                catch (Exception soc) {
                    // empty catch block
                }
                return;
            }
            String method = request.getMethod();
            if ("GET".equals(method) || "POST".equals(method)) {
                this.execPostOrGet(method, request, seqId);
            } else {
                this.execNotPostAndGet(method, request);
            }
        }
        catch (Exception e) {
            if (conn != null) {
                conn.destroy();
            }
            throw e;
        }
        catch (Error er) {
            if (conn != null) {
                conn.destroy();
            }
            throw er;
        }
    }

    private void execNotPostAndGet(String method, HttpdRequest request) throws Exception {
        if ("HEAD".equals(method)) {
            this.executionHead(request);
        } else if ("OPTIONS".equals(method)) {
            this.executionOptions(request);
        } else {
            this.executionNoSupprtMethd(request);
        }
        this.closeConnection(request.getConnectionInfo());
    }

    private void executionHead(HttpdRequest request) throws Exception {
        int state = -1;
        String authHeader = null;
        HttpdAuthManager auth = (HttpdAuthManager)GlobalManager.getValue((String)"AUTH_MANAGER");
        HttpdAuthElement emt = null;
        if (auth != null && (emt = auth.getElement(request.getUrlPath())) != null) {
            HttpdAuthUsers users = (HttpdAuthUsers)GlobalManager.getValue((String)"USERS_MANAGER");
            if (emt.getAuthType() == 0) {
                if (!HttpdAuthBasic.isAuth(request, emt, users, request.getHeader())) {
                    authHeader = HttpdAuthBasic.getSendAuth(emt);
                    state = 401;
                }
            } else if (emt.getAuthType() == 1 && !HttpdAuthDigest.isAuth(request, emt, users, request.getHeader())) {
                authHeader = HttpdAuthDigest.getSendAuth(emt);
                state = 401;
            }
        }
        long last = -1L;
        if (state == -1) {
            boolean pub = false;
            boolean sc = false;
            HttpdExecutionManager pubMan = (HttpdExecutionManager)GlobalManager.getValue((String)"PUBLIC_PAGE_MANAGER");
            HttpdExecutionManager scMan = (HttpdExecutionManager)GlobalManager.getValue((String)"APPLICATION_PAGE_MANAGER");
            last = pubMan.getFileTime(request.getUrlPath());
            if (last == -1L) {
                last = scMan.getFileTime(request.getUrlPath());
                if (last != -1L) {
                    sc = true;
                }
            } else {
                pub = true;
            }
            if (last == -1L) {
                state = 404;
            }
            if (pub && !pubMan.isRead(request.getUrlPath()) || sc && !scMan.isRead(request.getUrlPath())) {
                state = 403;
            } else {
                state = 200;
                if (HttpdUtil.isClientCache(request.getHeader(), last)) {
                    state = 304;
                }
            }
        }
        HttpdHeaders header = null;
        if (authHeader != null) {
            header = new HttpdHeaders();
            header.addHeader("WWW-Authenticate", authHeader);
        }
        this.returnHeader(request, state, last, -1L, -1, header);
    }

    private void executionOptions(HttpdRequest request) throws Exception {
        HttpdResponse res = HttpdResponseInstance.createResponse(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
        res.destroy();
    }

    private void executionNoSupprtMethd(HttpdRequest request) throws Exception {
        WriteError.output(request, null, 501, null);
    }

    private void execPostOrGet(String method, HttpdRequest request, int seqId) throws Exception {
        try {
            this.executionTargetURL(request);
        }
        catch (BaseScriptException se) {
            ScriptException sc = se.getScriptException();
            LOG.error((Object)("error(id:" + seqId + "):"), (Throwable)sc);
            StringBuilder buf = new StringBuilder();
            buf.append(sc.getMessage()).append("<BR><BR>");
            if (se.getErrorScriptInfo() != null) {
                buf.append(se.getErrorScriptInfo());
            }
            String msg = buf.toString();
            buf = null;
            try {
                WriteError.output(request, null, 500, msg);
            }
            catch (Exception exception) {}
        }
        catch (HttpdStateException hs) {
            if (hs.getState() >= 500) {
                if (request != null) {
                    LOG.error((Object)("url:(id:" + seqId + "):" + request.getUrlPath() + " - status(" + hs.getState() + ") error"), (Throwable)hs);
                }
            } else if (request != null) {
                LOG.warn((Object)("url:(id:" + seqId + ")" + request.getUrlPath() + " - status(" + hs.getState() + ") warning"), (Throwable)hs);
            }
            try {
                WriteError.output(request, null, hs.getState(), hs.getErrorMessage());
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            LOG.error((Object)("error(id:" + seqId + "):"), (Throwable)e);
            try {
                WriteError.output(request, null, 500, e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void executionTargetURL(HttpdRequest request) throws Exception {
        block20: {
            HttpdResponse resp = null;
            try {
                if (request.getUrlPath().startsWith("/%00i%00m%00g_")) {
                    ImageManagerReader im = new ImageManagerReader(request);
                    if (HttpdUtil.isClientCache(request.getHeader(), im.getLastTime())) {
                        this.returnHeader(request, 304, im.getLastTime(), request.getKeepAliveTimeout(), request.getKeepAliveCount(), null);
                    } else {
                        resp = im.getResponse(request);
                    }
                } else {
                    boolean pub = false;
                    boolean sc = false;
                    HttpdExecutionManager pubMan = (HttpdExecutionManager)GlobalManager.getValue((String)"PUBLIC_PAGE_MANAGER");
                    HttpdExecutionManager scMan = (HttpdExecutionManager)GlobalManager.getValue((String)"APPLICATION_PAGE_MANAGER");
                    String path = request.getUrlPath();
                    if (pubMan.isPath(path) && !path.endsWith(".ms")) {
                        pub = true;
                    } else if (scMan.isPath(path)) {
                        sc = true;
                    }
                    if (pub || sc) {
                        if (pub && !pubMan.isRead(path) || sc && !scMan.isRead(path)) {
                            throw new HttpdStateException(403);
                        }
                    } else {
                        throw new HttpdStateException(404, "\u6307\u5b9a\u30d1\u30b9[" + request.getUrlPath() + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                    }
                    HttpdExecutionManager man = null;
                    if (pub) {
                        man = pubMan;
                        sc = false;
                    } else if (sc) {
                        man = scMan;
                        pub = false;
                    }
                    if (sc && this.isAuth(request)) {
                        return;
                    }
                    long last = man.getFileTime(path);
                    if (HttpdUtil.isClientCache(request.getHeader(), last)) {
                        this.returnHeader(request, 304, last, request.getKeepAliveTimeout(), request.getKeepAliveCount(), null);
                    } else {
                        resp = man.get(request);
                    }
                }
                resp = null;
            }
            finally {
                if (resp == null) break block20;
                resp.flush();
                resp.destroy();
            }
        }
    }

    private void returnHeader(HttpdRequest request, int state, long date, long timeout, int count, HttpdHeaders header) throws Exception {
        HttpdResponse res = HttpdResponseInstance.createResponse(request, request.getUrlPath(), state, request.getKeepAliveTimeout(), request.getKeepAliveCount());
        if (date == -1L) {
            res.getHeader().setHeader("Date", HttpdTimestamp.getTimestamp(0L));
        } else {
            res.getHeader().setHeader("Date", HttpdTimestamp.getTimestamp(date));
        }
        res.getHeader().add(header);
        res.destroy();
    }

    private boolean isAuth(HttpdRequest request) throws Exception {
        String authHeader = null;
        HttpdAuthManager auth = (HttpdAuthManager)GlobalManager.getValue((String)"AUTH_MANAGER");
        HttpdAuthElement emt = null;
        if (auth != null && (emt = auth.getElement(request.getUrlPath())) != null) {
            HttpdAuthUsers users = (HttpdAuthUsers)GlobalManager.getValue((String)"USERS_MANAGER");
            if (emt.getAuthType() == 0) {
                if (!HttpdAuthBasic.isAuth(request, emt, users, request.getHeader())) {
                    authHeader = HttpdAuthBasic.getSendAuth(emt);
                }
            } else if (emt.getAuthType() == 1 && !HttpdAuthDigest.isAuth(request, emt, users, request.getHeader())) {
                authHeader = HttpdAuthDigest.getSendAuth(emt);
            }
        }
        if (authHeader != null) {
            HttpdHeaders addHeader = new HttpdHeaders();
            addHeader.addHeader("WWW-Authenticate", authHeader);
            WriteError.output(request, addHeader, 401, null);
            return true;
        }
        return false;
    }

    private static final void putGzip(HttpdRequest req) {
        IniFile config = (IniFile)GlobalManager.getValue((String)"CONFIG_MANAGER");
        boolean flag = ConvIniParam.getBoolean((String)config.get("server", "gzip", 0));
        req.setGzip(flag);
    }

    private void closeConnection(HttpConnectionInfo conn) {
        if (conn != null) {
            conn.destroy();
        }
    }
}

