/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.comet;

import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpdRequest;

class ConnectComet {
    private HttpConnectionInfo connectionInfo = null;
    private HttpdRequest request = null;
    private long connectionTime = -1L;

    public ConnectComet(HttpdRequest request) {
        this.request = request;
        this.connectionInfo = request.getConnectionInfo();
        this.connectionTime = System.currentTimeMillis();
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void destroy() {
        this.clear();
        if (this.getConnectionInfo() != null) {
            this.getConnectionInfo().destroy();
        }
    }

    public void clear() {
        if (this.connectionInfo != null) {
            try {
                this.connectionInfo.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.request = null;
        this.connectionTime = -1L;
    }

    public void cancel() {
        this.connectionInfo = null;
        this.request = null;
        this.connectionTime = -1L;
    }

    public HttpdRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpdRequest request) {
        this.request = request;
    }

    public HttpConnectionInfo getConnectionInfo() {
        if (this.connectionInfo != null && this.connectionInfo.isUse()) {
            return this.connectionInfo;
        }
        return null;
    }

    public long getConnectionTime() {
        return this.connectionTime;
    }

    public boolean isConnection() {
        boolean ret = false;
        try {
            ret = this.request != null && this.request.isUse();
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }
}

