/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Key {
    private static PreparedStatement getReferenceCols;
    private static boolean printedHeader;

    public static void doKeys(Connection connection) throws SQLException {
        printedHeader = false;
        getReferenceCols = connection.prepareStatement("SELECT CG.TABLEID, CG.DESCRIPTOR FROM SYS.SYSCONGLOMERATES CG, SYS.SYSKEYS K WHERE K.CONSTRAINTID = ? AND K.CONGLOMERATEID = CG.CONGLOMERATEID");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT CS.CONSTRAINTNAME, CS.TYPE, CS.TABLEID, CS.CONSTRAINTID, CS.SCHEMAID, CG.DESCRIPTOR, CG.ISCONSTRAINT FROM SYS.SYSCONSTRAINTS CS, SYS.SYSCONGLOMERATES CG, SYS.SYSKEYS K WHERE CS.STATE != 'D' AND CS.CONSTRAINTID = K.CONSTRAINTID AND CG.CONGLOMERATEID = K.CONGLOMERATEID ORDER BY CS.TABLEID");
        DB_Key.createKeysFrom(resultSet);
        resultSet = statement.executeQuery("SELECT CS.CONSTRAINTNAME, CS.TYPE, CS.TABLEID, CS.CONSTRAINTID, CS.SCHEMAID, CG.DESCRIPTOR, CG.ISCONSTRAINT, K.DELETERULE, K.UPDATERULE, K.KEYCONSTRAINTID FROM SYS.SYSCONSTRAINTS CS, SYS.SYSCONGLOMERATES CG, SYS.SYSFOREIGNKEYS K WHERE CS.STATE != 'D' AND CS.CONSTRAINTID = K.CONSTRAINTID AND CG.CONGLOMERATEID = K.CONGLOMERATEID ORDER BY CS.TABLEID");
        DB_Key.createKeysFrom(resultSet);
        getReferenceCols.close();
        statement.close();
        resultSet.close();
    }

    private static void createKeysFrom(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            String string;
            String string2;
            if (!resultSet.getBoolean(7) || dblook.isExcludedTable(string2 = dblook.lookupTableId(string = resultSet.getString(3)))) continue;
            if (bl) {
                DB_Key.printHeader();
                if (resultSet.getString(2).equals("F")) {
                    Logs.reportMessage("DBLOOK_ForeignHeader");
                } else {
                    Logs.reportMessage("DBLOOK_PrimUniqueHeader");
                }
            }
            StringBuffer stringBuffer = DB_Key.createKeyString(string, string2, resultSet);
            if (resultSet.getString(2).equals("F")) {
                stringBuffer.append(DB_Key.makeFKReferenceClause(resultSet.getString(10), resultSet.getString(8).charAt(0), resultSet.getString(9).charAt(0)));
            }
            Logs.writeToNewDDL(stringBuffer.toString());
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
    }

    private static StringBuffer createKeyString(String string, String string2, ResultSet resultSet) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("ALTER TABLE ");
        stringBuffer.append(string2);
        stringBuffer.append(" ADD");
        String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
        stringBuffer.append(" CONSTRAINT ");
        stringBuffer.append(string3);
        stringBuffer.append(DB_Key.expandKeyType(resultSet.getString(2).charAt(0)));
        stringBuffer.append("(");
        stringBuffer.append(dblook.getColumnListFromDescription(string, resultSet.getString(6)));
        stringBuffer.append(")");
        return stringBuffer;
    }

    private static String expandKeyType(char c) {
        switch (c) {
            case 'P': {
                return " PRIMARY KEY ";
            }
            case 'U': {
                return " UNIQUE ";
            }
            case 'F': {
                return " FOREIGN KEY ";
            }
        }
        Logs.debug("INTERNAL ERROR: unexpected key type" + c, (String)null);
        return "";
    }

    private static String makeFKReferenceClause(String string, char c, char c2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        getReferenceCols.setString(1, string);
        ResultSet resultSet = getReferenceCols.executeQuery();
        resultSet.next();
        stringBuffer.append(" REFERENCES ");
        stringBuffer.append(dblook.lookupTableId(resultSet.getString(1)));
        stringBuffer.append(" (");
        stringBuffer.append(dblook.getColumnListFromDescription(resultSet.getString(1), resultSet.getString(2)));
        stringBuffer.append(")");
        stringBuffer.append(" ON DELETE ");
        switch (c) {
            case 'R': {
                stringBuffer.append("NO ACTION");
                break;
            }
            case 'S': {
                stringBuffer.append("RESTRICT");
                break;
            }
            case 'C': {
                stringBuffer.append("CASCADE");
                break;
            }
            case 'U': {
                stringBuffer.append("SET NULL");
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected 'on-delete' action: " + c, (String)null);
            }
        }
        stringBuffer.append(" ON UPDATE ");
        switch (c2) {
            case 'R': {
                stringBuffer.append("NO ACTION");
                break;
            }
            case 'S': {
                stringBuffer.append("RESTRICT");
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected 'on-update' action: " + c2, (String)null);
            }
        }
        resultSet.close();
        return stringBuffer.toString();
    }

    private static void printHeader() {
        if (printedHeader) {
            return;
        }
        Logs.reportString("----------------------------------------------");
        Logs.reportMessage("DBLOOK_KeysHeader");
        Logs.reportString("----------------------------------------------\n");
        printedHeader = true;
    }
}

