package org.maachang.comet.httpd ;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * HTTPDバイナリパラメータ.
 *
 * @version 2007/09/02
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class HttpdBinary {
    
    /**
     * オリジナルファイル.
     */
    private String originalName = null ;
    
    /**
     * MimeType.
     */
    private String mimeType = null ;
    
    /**
     * ファイルオブジェクト.
     */
    private byte[] binary = null ;
    
    /**
     * 対象データ長.
     */
    private int length = 0 ;
    
    /**
     * コンストラクタ.
     */
    private HttpdBinary() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を設定してオブジェクトを生成します.
     * <BR>
     * @param originalName オリジナルファイル名を設定します.
     * @param mimeType 対象のMimeTypeを設定します.
     * @param binary 対象バイナリを設定します.
     * @exception Exception 例外.
     */
    public HttpdBinary( String originalName,String mimeType,byte[] binary )
        throws Exception {
        if( originalName == null || ( originalName = originalName.trim() ).length() <= 0 ||
            mimeType == null || ( mimeType = mimeType.trim() ).length() <= 0 ||
            binary == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.originalName = originalName ;
        this.mimeType = mimeType ;
        this.binary = binary ;
        this.length = binary.length ;
    }
    
    /**
     * オリジナルファイル名を取得.
     * <BR><BR>
     * オリジナルファイル名を取得します.
     * <BR>
     * @return String 対象のオリジナルファイル名が返されます.
     */
    public String getOriginalName() {
        return originalName ;
    }
    
    /**
     * MimeTypeを取得.
     * <BR><BR>
     * MimeTypeを取得します.
     * <BR>
     * @return String MimeTypeが返されます.
     */
    public String getMimeType() {
        return mimeType ;
    }
    
    /**
     * 対象バイナリを取得.
     * <BR><BR>
     * 対象のバイナリ情報が返されます.
     * <BR>
     * @return byte[] 対象のバイナリが返されます.
     */
    public byte[] getBinary() {
        return binary ;
    }
    
    /**
     * 対象バイナリを取得.
     * <BR><BR>
     * 対象のバイナリ情報が返されます.
     * <BR>
     * @return InputStream 対象のバイナリがInputStreamで返されます.
     */
    public InputStream getInputStream() {
        return new ByteArrayInputStream( binary ) ;
    }
    
    /**
     * 情報長を取得.
     * <BR><BR>
     * 情報長が返されます.
     * <BR>
     * @return int 情報長が返されます.
     */
    public int getLength() {
        return length ;
    }
    
    /**
     * 文字列を取得.
     */
    public String toString() {
        return originalName ;
    }
}
