package org.maachang.comet.httpd.engine.script;

import javax.script.ScriptContext;
import javax.script.ScriptException;

import org.maachang.comet.httpd.engine.script.js.JsDef;

/**
 * スクリプトを強制的に途中で終了する処理.
 * 
 * @version 2007/08/24
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class EndScript {
    /**
     * 途中終了用JavaScript側変数名.
     */
    private static final String RESULT_CODE = JsDef.JS_EXIT_BY_RESULT ;
    
    /**
     * 強制終了用例外名.
     */
    private static final String END_SCRIPT_EXCEPTION_NAME =
        "org.maachang.comet.httpd.engine.script.endscriptexception" ;
    
    private static final EndScriptException ext = new EndScriptException() ;
    
    /**
     * スクリプト途中終了処理.
     * <BR><BR>
     * スクリプトを途中で終了させます.
     * <BR>
     * @exception EndScriptException スクリプト途中終了用例外.
     */
    public static final void exit()
        throws EndScriptException {
        throw ext ;
    }
    
    /**
     * 強制終了のチェック.
     * <BR><BR>
     * javax.script.ScriptExceptionが[EndScript#exit()]で発生したかチェック.
     * <BR>
     * @param se 対象のScriptExceptionを設定します.
     */
    public static final boolean isEndScript( ScriptException se ) {
        if( se == null ) {
            return false ;
        }
        String msg = se.getMessage().trim().toLowerCase() ;
        if( msg.length() <= 0 ) {
            return false ;
        }
        if( msg.indexOf( END_SCRIPT_EXCEPTION_NAME ) != -1 ) {
            return true ;
        }
        return false ;
    }
    
    /**
     * 処理結果内容を取得.
     * <BR><BR>
     * 途中終了での処理結果内容を取得します.
     * <BR>
     * @param context 対象のコンテキストを設定します.
     * @return Object 処理結果内容が返されます.
     */
    public static final Object getEndByResult( ScriptContext context ) {
        return context.getBindings( ScriptContext.ENGINE_SCOPE ).get( RESULT_CODE ) ;
    }
}

/**
 * 強制終了用例外.
 */
class EndScriptException extends Exception {
    private static final long serialVersionUID = 6550218155255562199L;
    public EndScriptException() {
        super() ;
    }
}
