package org.maachang.comet.net ;

import java.util.LinkedList;

import org.maachang.comet.httpd.HttpSocket;

/**
 * 受信情報を保持したソケットオブジェクト管理キュー.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class HttpUseQueue {
    private LinkedList<HttpSocket> queue = null ;
    
    public HttpUseQueue() {
        queue = new LinkedList<HttpSocket>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( HttpSocket accept ) {
        if( queue == null || accept == null || accept.isClosed() == true ) {
            return ;
        }
        queue.add( accept ) ;
    }
    
    public synchronized HttpSocket getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
}
