/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

public class ArrayBinary {
    protected static final int MAX_LENGTH = 0x2000000;
    private static final int BUFFER = 4096;
    private byte[] binary = null;
    private int length = 0;

    public ArrayBinary() {
        this(-1);
    }

    public ArrayBinary(int size) {
        if (size <= 0) {
            size = 4096;
        }
        this.binary = new byte[size];
        this.length = 0;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.binary = null;
        this.length = 0;
    }

    public void reset() {
        if (this.binary.length == 4096) {
            this.length = 0;
        } else {
            this.binary = new byte[4096];
            this.length = 0;
        }
    }

    public void write(int b) throws Exception {
        if (this.binary.length <= this.length) {
            byte[] t = this.binary;
            int iLen = t.length * 2;
            this.binary = new byte[iLen];
            System.arraycopy(t, 0, this.binary, 0, t.length);
            byte[] byArray = null;
        }
        this.binary[this.length] = (byte)(b & 0xFF);
        ++this.length;
    }

    public void write(byte[] binary) throws Exception {
        if (binary == null || binary.length <= 0) {
            return;
        }
        int len = binary.length;
        int i = 0;
        while (i < len) {
            this.write(binary[i] & 0xFF);
            ++i;
        }
    }

    public byte getByte(int no) {
        return this.binary[no];
    }

    public byte[] getRawBinary() {
        return this.binary;
    }

    public byte[] getBinary() {
        return this.getBinary(0);
    }

    public byte[] getBinary(int length) {
        if (length <= 0) {
            length = this.length;
        }
        if (this.length < length) {
            length = this.length;
        }
        byte[] ret = new byte[length];
        System.arraycopy(this.binary, 0, ret, 0, length);
        return ret;
    }

    public int length() {
        return this.length;
    }
}

