/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.util.Arrays;
import org.maachang.dbm.engine.MSector;
import org.maachang.util.ConvertParam;

class ValueSector {
    public static final int HEADER_LENGTH = 14;
    private int beforeFileNo = -1;
    private int beforeFilePos = -1;
    private int nextFileNo = -1;
    private int nextFilePos = -1;
    private int length = 0;
    private byte[] data = null;
    private int position = -1;
    private int fileNo = -1;

    public void setBeforeFileNo(int beforeFileNo) {
        this.beforeFileNo = beforeFileNo;
    }

    public int getBeforeFileNo() {
        return this.beforeFileNo;
    }

    public void setBeforeFilePos(int beforeFilePos) {
        this.beforeFilePos = beforeFilePos;
    }

    public int getBeforeFilePos() {
        return this.beforeFilePos;
    }

    public void setNextFileNo(int nextFileNo) {
        this.nextFileNo = nextFileNo;
    }

    public int getNextFileNo() {
        return this.nextFileNo;
    }

    public void setNextFilePos(int nextFilePos) {
        this.nextFilePos = nextFilePos;
    }

    public int getNextFilePos() {
        return this.nextFilePos;
    }

    public void setLength(int length) {
        if (length < 0 || length > MSector.ONE_DATA) {
            return;
        }
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        if (this.data == null) {
            this.data = new byte[MSector.ONE_DATA];
        }
        return this.data;
    }

    public byte[] read() throws Exception {
        if (this.length <= 0) {
            return null;
        }
        byte[] ret = new byte[this.length];
        System.arraycopy(this.data, 0, ret, 0, this.length);
        return ret;
    }

    public int read(byte[] out, int pos) throws Exception {
        return this.read(out, pos, 0, out.length);
    }

    public int read(byte[] out, int pos, int offset, int length) throws Exception {
        if (pos + length >= this.length) {
            length = this.length - pos;
        }
        System.arraycopy(this.data, pos, out, offset, length);
        return length;
    }

    public void write(byte[] in, int pos) throws Exception {
        this.write(in, pos, 0, in.length);
    }

    public void write(byte[] in, int pos, int offset, int length) throws Exception {
        if (pos + length > MSector.ONE_DATA) {
            throw new IllegalArgumentException("\u6307\u5b9a\u6761\u4ef6(pos:" + pos + " len:" + length + ")\u306f\uff11\u30bb\u30af\u30bf\u7bc4\u56f2\u3092\u8d85\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.data == null) {
            this.data = new byte[MSector.ONE_DATA];
        }
        System.arraycopy(in, offset, this.data, pos, length);
        if (this.length <= pos + length) {
            this.length = pos + length;
        }
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setFileNo(int fileNo) {
        this.fileNo = fileNo;
    }

    public int getFileNo() {
        return this.fileNo;
    }

    protected ValueSector copy() {
        ValueSector ret = new ValueSector();
        ret.beforeFileNo = this.beforeFileNo;
        ret.beforeFilePos = this.beforeFilePos;
        ret.nextFileNo = this.nextFileNo;
        ret.nextFilePos = this.nextFilePos;
        ret.length = this.length;
        ret.position = this.position;
        ret.fileNo = this.fileNo;
        System.arraycopy(this.data, 0, ret.data, 0, this.length);
        return ret;
    }

    protected void clear() {
        this.beforeFileNo = -1;
        this.beforeFilePos = -1;
        this.nextFileNo = -1;
        this.nextFilePos = -1;
        this.length = -1;
        this.position = -1;
        this.fileNo = -1;
        Arrays.fill(this.data, (byte)0);
    }

    protected static final ValueSector load(byte[] binary) throws Exception {
        if (binary == null || binary.length != MSector.ONE_SECTOR && binary.length != 14) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u30d0\u30a4\u30ca\u30ea\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ValueSector ret = new ValueSector();
        int pnt = 0;
        ret.beforeFileNo = ConvertParam.convertShort((int)pnt, (byte[])binary) & 0xFFFF;
        ret.beforeFileNo = (ret.beforeFileNo & 0xFFFFF400) != 0 ? -1 : ret.beforeFileNo;
        ret.beforeFilePos = ConvertParam.convertInt((int)(pnt += 2), (byte[])binary);
        ret.nextFileNo = ConvertParam.convertShort((int)(pnt += 4), (byte[])binary) & 0xFFFF;
        ret.nextFileNo = (ret.nextFileNo & 0xFFFFF400) != 0 ? -1 : ret.nextFileNo;
        ret.nextFilePos = ConvertParam.convertInt((int)(pnt += 2), (byte[])binary);
        ret.length = ConvertParam.convertShort((int)(pnt += 4), (byte[])binary) & 0xFFFF;
        pnt += 2;
        if (binary.length == 14) {
            return ret;
        }
        ret.data = new byte[MSector.ONE_DATA];
        System.arraycopy(binary, pnt, ret.data, 0, ret.length);
        return ret;
    }

    protected byte[] save() throws Exception {
        if (this.data == null || this.length <= 0) {
            throw new IOException("\u4fdd\u5b58\u5bfe\u8c61\u306e\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        byte[] ret = new byte[MSector.ONE_SECTOR];
        int pnt = 0;
        ConvertParam.convertShort((byte[])ret, (int)pnt, (short)((short)(this.beforeFileNo & 0xFFFF)));
        ConvertParam.convertInt((byte[])ret, (int)(pnt += 2), (int)this.beforeFilePos);
        ConvertParam.convertShort((byte[])ret, (int)(pnt += 4), (short)((short)(this.nextFileNo & 0xFFFF)));
        ConvertParam.convertInt((byte[])ret, (int)(pnt += 2), (int)this.nextFilePos);
        ConvertParam.convertShort((byte[])ret, (int)(pnt += 4), (short)((short)(this.length & 0xFFFF)));
        System.arraycopy(this.data, 0, ret, pnt += 2, this.length);
        return ret;
    }
}

