/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpSocket;
import org.maachang.comet.net.HttpSocketManager;
import org.maachang.comet.net.HttpUseQueue;
import org.maachang.comet.net.KeepAliveTimerManager;
import org.maachang.comet.net.NetHttpConnectionInfoImpl;

class NetReceiveThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(NetReceiveThread.class);
    private KeepAliveTimerManager timeMan = null;
    private HttpSocketManager manager = null;
    private HttpUseQueue queue = null;
    private volatile boolean stopFlag = true;

    private NetReceiveThread() {
    }

    public NetReceiveThread(KeepAliveTimerManager timerManager, HttpSocketManager manager) throws Exception {
        this.timeMan = timerManager;
        this.manager = manager;
        this.queue = new HttpUseQueue();
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public HttpUseQueue getUseQueue() {
        return this.queue;
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            try {
                int len = this.manager.size();
                if (len > 0) {
                    int i = len - 1;
                    while (i >= 0) {
                        HttpSocket s = null;
                        try {
                            s = this.manager.get(i);
                            if (s.isClosed()) {
                                this.manager.remove(i);
                            } else {
                                s.startReceive();
                                if (s.isReceive()) {
                                    this.manager.remove(i);
                                    HttpConnectionInfo conn = null;
                                    conn = s.getConnectionInfo();
                                    if (conn == null) {
                                        conn = new NetHttpConnectionInfoImpl(s, this.manager, this.timeMan);
                                        s.setConnectionInfo(conn);
                                    } else {
                                        this.timeMan.remove(conn);
                                    }
                                    this.queue.append(s);
                                }
                            }
                        }
                        catch (IOException io) {
                            if (s != null) {
                                s.destroy();
                            }
                            this.manager.remove(i);
                        }
                        catch (InterruptedException ite) {
                            endFlag = true;
                        }
                        catch (NullPointerException ite) {
                        }
                        catch (OutOfMemoryError mem) {
                            LOG.error((Object)"## out-of-memory-error", (Throwable)mem);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"## error", (Throwable)e);
                        }
                        catch (ThreadDeath td) {
                            endFlag = true;
                            threadDeach = td;
                        }
                        --i;
                    }
                }
                Thread.sleep(5L);
            }
            catch (InterruptedException ie) {
                endFlag = true;
            }
        }
        this.manager = null;
        this.queue = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

