package org.maachang.comet;

import org.maachang.comet.conf.BaseConfig;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.conf.StartupConfig;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.dao.dbms.ctbl.CreateTable;
import org.maachang.util.FileUtil;

/**
 * MaachangComet-テーブル生成オブジェクト.
 * 
 * @version 2007/09/30
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class OutputTable {
    
    /**
     * コンストラクタ.
     */
    private OutputTable() {
        
    }
    
    /**
     * メインメソッド.
     * <BR><BR>
     * @param args Javaからのパラメータが設定されます.
     * @exception Exception 例外.
     */
    public static final void main( String[] args )
        throws Exception {
        new OutputTable().execution( args ) ;
    }
    
    /**
     * 実行処理.
     */
    private void execution( String[] args )
        throws Exception {
        String basePath = StartupConfig.getPath( "." ) ;
        RecordFactory factory = getRecordFactory( basePath ) ;
        if( factory == null ) {
            System.out.println( "データベース接続が無効です." ) ;
            return ;
        }
        String tablePath = basePath + MaachangDef.DIRECTORY_TABLE ;
        String modelPath = basePath + MaachangDef.DIRECTORY_MODEL ;
        String param = null ;
        if( args == null || args.length <= 0 ) {
            param = null ;
        }
        else {
            param = args[ 0 ] ;
        }
        CreateTable.create( false,tablePath,modelPath,param,factory ) ;
        factory.clear() ;
    }
    
    /**
     * コンフィグ情報を読み込む.
     */
    private RecordFactory getRecordFactory( String path )
        throws Exception {
        path = path+MaachangDef.DIRECTORY_CONFIG ;
        path = FileUtil.getFullPath( path )+FileUtil.FILE_SPACE ;
        BaseConfig bconf = StartupConfig.getBaseConfig( path ) ;
        int len = bconf.size() ;
        IniFile config = new IniFile() ;
        for( int i = 0 ; i < len ; i ++ ) {
            String name = bconf.getConfig( i ) ;
            if( name == null || ( name = name.trim() ).length() <= 0 ) {
                continue ;
            }
            StartupConfig.readConfig( config,path,name ) ;
        }
        return StartupConfig.getRecordFactory( false,config ) ;
    }

}
