package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.MaachangDef;
import org.maachang.comet.httpd.engine.script.ScriptDef;

/**
 * Filterスクリプト.
 * 
 * @version 2007/08/29
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class FilterScript extends AbstractScript {
    
    private FilterScript() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を指定してオブジェクトを生成します.
     * <BR>
     * @param path 対象のパスを設定します.
     * @param currentDirectory カレントディレクトリを設定します.
     * @exception Exception 例外.
     */
    public FilterScript( String path,String currentDirectory )
        throws Exception {
        this.create( "Filter",MaachangDef.DIRECTORY_APPLICATION,
            path,currentDirectory ) ;
    }
    
    /**
     * スクリプトタイプを取得.
     * <BR><BR>
     * スクリプトタイプを取得します.
     * <BR>
     * @return int スクリプトタイプが返されます.
     */
    public int getScriptType() {
        return ScriptDef.SCRIPT_TYPE_BY_FILTER ;
    }
    
    /**
     * Headerスクリプトを設定.
     */
    protected String addHeaderScript() throws Exception {
        return ScriptDef.ADD_SCRIPT ;
    }
    
    /**
     * Footerスクリプトを設定.
     */
    protected String addFooterScript() throws Exception {
        return null ;
    }
}
