package org.maachang.comet.net ;

import org.maachang.comet.httpd.HttpConnectionInfo;

/**
 * KeepAliveタイマー管理.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
class KeepAliveTimerManager {
    
    private static final long MIN_TIMEOUT = 1000L ;
    private static final long MAX_TIMEOUT = 120000L ;
    private static final long DEF_TIMEOUT = 3000L ;
    private static final int MIN_KEEP_ALIVE_COUNT = 5 ;
    private static final int MAX_KEEP_ALIVE_COUNT = 999 ;
    private static final int DEF_KEEP_ALIVE_COUNT = 100 ;
    
    private long timeout = -1L ;
    private int keepAliveCount = -1 ;
    private KeepAliveTimeoutThread timeoutThread = null ;
    
    public KeepAliveTimerManager() {
        this( DEF_TIMEOUT ) ;
    }
    
    public KeepAliveTimerManager( long timeout ) {
        this( timeout,DEF_KEEP_ALIVE_COUNT ) ;
    }
    
    public KeepAliveTimerManager( long timeout,int keepAliveCount ) {
        if( timeout <= MIN_TIMEOUT ) {
            timeout = MIN_TIMEOUT ;
        }
        else if( timeout >= MAX_TIMEOUT ) {
            timeout = MAX_TIMEOUT ;
        }
        if( keepAliveCount <= MIN_KEEP_ALIVE_COUNT ) {
            keepAliveCount = MIN_KEEP_ALIVE_COUNT ;
        }
        else if( keepAliveCount >= MAX_KEEP_ALIVE_COUNT ) {
            keepAliveCount = MAX_KEEP_ALIVE_COUNT ;
        }
        this.timeout = timeout ;
        this.keepAliveCount = keepAliveCount ;
        this.timeoutThread = new KeepAliveTimeoutThread() ;
    }
    
    public void append( HttpConnectionInfo conn ) {
        this.timeoutThread.append( conn ) ;
    }
    
    public void remove( HttpConnectionInfo conn ) {
        this.timeoutThread.remove( conn ) ;
    }
    
    public long getTimeout() {
        return this.timeout ;
    }
    
    public int getKeepAliveCount() {
        return this.keepAliveCount ;
    }
    
}
