/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.dbm.engine.MDbmDefine;

public class MDbmEnv {
    public static final int HASH;
    public static final int KEY;
    public static final int MAX_KEY_LENGTH;
    public static final int SECTOR;
    public static final int ONE_SECTOR_BY_SECTOR_SIZE;

    static {
        Log logOut = LogFactory.getLog(MDbmEnv.class);
        if (MDbmDefine.OUT_MODE && logOut.isDebugEnabled()) {
            logOut.debug((Object)"## MDbm version:b1.10");
        }
        int n = 20;
        if (System.getProperty("mdbm.hash") != null) {
            try {
                n = Integer.parseInt(System.getProperty("mdbm.hash"));
                if (n >= 26) {
                    n = 26;
                } else if (n <= 16) {
                    n = 16;
                }
            }
            catch (Exception e) {
                n = 20;
            }
        }
        int hashSize = 1048575;
        switch (n) {
            case 16: {
                hashSize = 65535;
                break;
            }
            case 17: {
                hashSize = 131071;
                break;
            }
            case 18: {
                hashSize = 262143;
                break;
            }
            case 19: {
                hashSize = 524287;
                break;
            }
            case 20: {
                hashSize = 1048575;
                break;
            }
            case 21: {
                hashSize = 0x1FFFFF;
                break;
            }
            case 22: {
                hashSize = 0x3FFFFF;
                break;
            }
            case 23: {
                hashSize = 0x7FFFFF;
                break;
            }
            case 24: {
                hashSize = 0xFFFFFF;
                break;
            }
            case 25: {
                hashSize = 0x1FFFFFF;
                break;
            }
            case 26: {
                hashSize = 0x3FFFFFF;
                break;
            }
            case 27: {
                hashSize = 0x7FFFFFF;
                break;
            }
            case 28: {
                hashSize = 0xFFFFFFF;
                break;
            }
            case 29: {
                hashSize = 0x1FFFFFFF;
                break;
            }
            case 30: {
                hashSize = 0x3FFFFFFF;
                break;
            }
            case 31: {
                hashSize = Integer.MAX_VALUE;
            }
        }
        HASH = hashSize + 1;
        if (MDbmDefine.OUT_MODE && logOut.isDebugEnabled()) {
            logOut.debug((Object)("## MDbmEnv.HASH:" + (hashSize + 1)));
        }
        n = 256;
        if (System.getProperty("mdbm.key") != null) {
            try {
                n = Integer.parseInt(System.getProperty("mdbm.key"));
                if (n >= 1024) {
                    n = 1024;
                } else if (n <= 64) {
                    n = 64;
                }
            }
            catch (Exception e) {
                n = 256;
            }
        }
        if ((n = n / 64 * 64) <= 64) {
            n = 64;
        }
        KEY = n;
        if (MDbmDefine.OUT_MODE && logOut.isDebugEnabled()) {
            logOut.debug((Object)("## MDbmEnv.KEY:" + n));
        }
        n = 15000000;
        if (System.getProperty("mdbm.maxLength") != null) {
            try {
                n = Integer.parseInt(System.getProperty("mdbm.maxLength"));
                if (n >= 50000000) {
                    n = 50000000;
                } else if (n <= 100000) {
                    n = 100000;
                }
            }
            catch (Exception e) {
                n = 15000000;
            }
        }
        if ((n = n / 100000 * 100000) <= 100000) {
            n = 100000;
        }
        MAX_KEY_LENGTH = n;
        if (MDbmDefine.OUT_MODE && logOut.isDebugEnabled()) {
            logOut.debug((Object)("## MDbmEnv.MAX_KEY_LENGTH:" + n));
        }
        n = 1024;
        if (System.getProperty("mdbm.sector") != null) {
            try {
                n = Integer.parseInt(System.getProperty("mdbm.sector"));
                if (n >= 8192) {
                    n = 8192;
                } else if (n <= 512) {
                    n = 512;
                }
            }
            catch (Exception e) {
                n = 1024;
            }
        }
        if ((n = n / 512 * 512) <= 512) {
            n = 512;
        }
        SECTOR = n;
        if (MDbmDefine.OUT_MODE && logOut.isDebugEnabled()) {
            logOut.debug((Object)("## MDbmEnv.SECTOR:" + n));
        }
        n = 524288;
        if (System.getProperty("mdbm.sector.file") != null) {
            try {
                n = Integer.parseInt(System.getProperty("mdbm.sector.file"));
                if (n >= 0x100000) {
                    n = 0x100000;
                } else if (n <= 32768) {
                    n = 32768;
                }
            }
            catch (Exception e) {
                n = 524288;
            }
        }
        if ((n = n / 32768 * 32768) <= 32768) {
            n = 32768;
        }
        ONE_SECTOR_BY_SECTOR_SIZE = n;
        if (MDbmDefine.OUT_MODE && logOut.isDebugEnabled()) {
            logOut.debug((Object)("## MDbmEnv.ONE_SECTOR_BY_SECTOR_SIZE:" + n));
        }
    }
}

