/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.server;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.conf.Config;
import org.maachang.conf.ReadConfigUtil;
import org.maachang.connector.ConnectorCallback;
import org.maachang.connector.ConnectorManager;
import org.maachang.connector.ConnectorService;
import org.maachang.session.engine.PersistenceDefine;
import org.maachang.session.engine.PersistenceEngine;
import org.maachang.session.engine.PersistenceService;
import org.maachang.session.server.PSessionCallback;

public class PSessionServerService {
    private static final Log LOG = LogFactory.getLog(PSessionServerService.class);
    private static final String SESSION_CONFIG = "./conf/session.conf";
    private ConnectorService service = null;

    public PSessionServerService() throws Exception {
        Config conf = PSessionServerService.readConfig();
        InetAddress addr = conf.getInetAddress("session-net", "bind-addr", 0);
        int port = conf.getInt("session-net", "bind-port", 0);
        int max = conf.getInt("session-net", "max", 0);
        int pool = conf.getInt("session-net", "thread", 0);
        this.createObject(addr, port, max, pool);
    }

    public PSessionServerService(InetAddress addr, int port, int max, int pool) throws Exception {
        this.createObject(addr, port, max, pool);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.service != null) {
            LOG.info((Object)"## PSessionServerService - \u7834\u68c4");
            this.service.destroy();
        }
    }

    public static final Config readConfig() throws Exception {
        Config conf = new Config();
        ReadConfigUtil.readConfig((Config)conf, (String)SESSION_CONFIG);
        return conf;
    }

    private void createObject(InetAddress addr, int port, int max, int pool) throws Exception {
        ConnectorService sv;
        PersistenceEngine engine = PersistenceService.getInstance().getEngine();
        if (engine == null || !engine.isUse()) {
            throw new IOException("PersistenceService\u304c\u958b\u59cb\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (port <= -1 || port >= 65536) {
            port = 3111;
        }
        if (max <= 0) {
            max = 30;
        }
        if (pool <= 0) {
            pool = 15;
        }
        if (addr != null) {
            LOG.info((Object)("## PSessionServerService - \u751f\u6210[ addr:" + addr.getHostAddress() + " port:" + port + " max:" + max + " pool:" + pool + "]"));
        } else {
            LOG.info((Object)("## PSessionServerService - \u751f\u6210[ addr:0.0.0.0 port:" + port + " max:" + max + " pool:" + pool + "]"));
        }
        ConnectorManager man = new ConnectorManager(addr, port, max);
        PSessionCallback call = new PSessionCallback(engine);
        this.service = sv = new ConnectorService(PersistenceDefine.PROTOCOL_HEADER, (ConnectorCallback)call, man, pool);
    }
}

