/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.server.protocol;

import org.maachang.session.engine.PersistenceEngine;
import org.maachang.session.server.protocol.ServerProtocol;
import org.maachang.session.server.protocol.SvCreateSessionIdProtocol;
import org.maachang.session.server.protocol.SvDeleteSessionIdProtocol;
import org.maachang.session.server.protocol.SvDeleteSessionTimeProtocol;
import org.maachang.session.server.protocol.SvErrorProtocol;
import org.maachang.session.server.protocol.SvGetSessionKeyProtocol;
import org.maachang.session.server.protocol.SvPutSessionKeyProtocol;
import org.maachang.session.server.protocol.SvRemoveSessionKeyProtocol;
import org.maachang.session.server.protocol.SvUpdateSessionIdProtocol;
import org.maachang.session.server.protocol.SvUseSessionIdProtocol;
import org.maachang.session.server.protocol.SvUseToSessionIdProtocol;
import org.maachang.util.ConvertParam;

public class IOServerProtocol {
    public static final ServerProtocol execution(PersistenceEngine pse, byte[] binary, int offset) throws Exception {
        int type = -1;
        try {
            int p = offset;
            type = ConvertParam.convertInt((int)p, (byte[])binary);
            p += 4;
            switch (type &= 0xFF) {
                case 1: {
                    return IOServerProtocol.createSession(pse, p, binary);
                }
                case 2: {
                    return IOServerProtocol.useSession(pse, p, binary);
                }
                case 3: {
                    return IOServerProtocol.deleteSession(pse, p, binary);
                }
                case 4: {
                    return IOServerProtocol.updateSession(pse, p, binary);
                }
                case 5: {
                    return IOServerProtocol.useToSessionId(pse, p, binary);
                }
                case 6: {
                    return IOServerProtocol.deleteSessionTime(pse, p, binary);
                }
                case 16: {
                    return IOServerProtocol.putValue(pse, p, binary);
                }
                case 17: {
                    return IOServerProtocol.removeValue(pse, p, binary);
                }
                case 18: {
                    return IOServerProtocol.getValue(pse, p, binary);
                }
            }
            return new SvErrorProtocol("\u30d7\u30ed\u30c8\u30b3\u30eb\u30bf\u30a4\u30d7[" + type + "]\u306f\u4e0d\u6b63\u3067\u3059");
        }
        catch (Exception e) {
            e.printStackTrace();
            String s = e.getMessage();
            s = s == null || (s = s.trim()).length() <= 0 ? "\u4f8b\u5916[" + e.getClass().getName() + "]\u304c\u767a\u751f\u3057\u307e\u3057\u305f" : String.valueOf(e.getClass().getName()) + ":" + s;
            return new SvErrorProtocol("[" + type + "] " + s);
        }
    }

    private static ServerProtocol createSession(PersistenceEngine pse, int p, byte[] binary) throws Exception {
        SvCreateSessionIdProtocol ret = new SvCreateSessionIdProtocol();
        String s = pse.createSessionId();
        if (s == null || s.length() <= 0) {
            return new SvErrorProtocol("\u30bb\u30c3\u30b7\u30e7\u30f3ID\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        ret.setResult(s);
        return ret;
    }

    private static ServerProtocol useSession(PersistenceEngine pse, int p, byte[] binary) throws Exception {
        SvUseSessionIdProtocol ret = new SvUseSessionIdProtocol(binary, p);
        if (ret.getSessionId() == null) {
            return new SvErrorProtocol("\u30bb\u30c3\u30b7\u30e7\u30f3ID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        boolean flg = pse.containsKey(ret.getSessionId());
        ret.setResult(new Boolean(flg));
        return ret;
    }

    private static ServerProtocol deleteSession(PersistenceEngine pse, int p, byte[] binary) throws Exception {
        SvDeleteSessionIdProtocol ret = new SvDeleteSessionIdProtocol(binary, p);
        if (ret.getSessionId() == null) {
            return new SvErrorProtocol("\u30bb\u30c3\u30b7\u30e7\u30f3ID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        pse.remove(ret.getSessionId());
        ret.setResult(null);
        return ret;
    }

    private static ServerProtocol updateSession(PersistenceEngine pse, int p, byte[] binary) throws Exception {
        SvUpdateSessionIdProtocol ret = new SvUpdateSessionIdProtocol(binary, p);
        if (ret.getSessionId() == null) {
            return new SvErrorProtocol("\u30bb\u30c3\u30b7\u30e7\u30f3ID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        long time = pse.getLastUpdateTime(ret.getSessionId());
        ret.setResult(new Long(time));
        return ret;
    }

    private static ServerProtocol useToSessionId(PersistenceEngine pse, int p, byte[] binary) throws Exception {
        SvUseToSessionIdProtocol ret = new SvUseToSessionIdProtocol(binary, p);
        if (ret.getSessionId() == null || !pse.containsKey(ret.getSessionId())) {
            ret.setResult(pse.createSessionId());
        } else {
            ret.setResult(ret.getSessionId());
        }
        return ret;
    }

    private static ServerProtocol deleteSessionTime(PersistenceEngine pse, int p, byte[] binary) throws Exception {
        SvDeleteSessionTimeProtocol ret = new SvDeleteSessionTimeProtocol();
        long time = pse.getDeleteSessionTime();
        ret.setResult(new Long(time));
        return ret;
    }

    private static ServerProtocol putValue(PersistenceEngine pse, int p, byte[] binary) throws Exception {
        SvPutSessionKeyProtocol ret = new SvPutSessionKeyProtocol(binary, p);
        if (ret.getSessionId() == null || ret.getKey() == null || ret.getValue() == null) {
            if (ret.getSessionId() == null) {
                return new SvErrorProtocol("\u30bb\u30c3\u30b7\u30e7\u30f3ID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            if (ret.getKey() == null) {
                return new SvErrorProtocol("\u8981\u7d20Key\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            if (ret.getValue() == null) {
                return new SvErrorProtocol("\u8981\u7d20Value\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
        }
        pse.put(ret.getSessionId(), ret.getKey(), ret.getValue());
        ret.setResult(null);
        return ret;
    }

    private static ServerProtocol removeValue(PersistenceEngine pse, int p, byte[] binary) throws Exception {
        SvRemoveSessionKeyProtocol ret = new SvRemoveSessionKeyProtocol(binary, p);
        if (ret.getSessionId() == null || ret.getKey() == null) {
            if (ret.getSessionId() == null) {
                return new SvErrorProtocol("\u30bb\u30c3\u30b7\u30e7\u30f3ID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            if (ret.getKey() == null) {
                return new SvErrorProtocol("\u8981\u7d20Key\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
        }
        pse.remove(ret.getSessionId(), ret.getKey());
        ret.setResult(null);
        return ret;
    }

    private static ServerProtocol getValue(PersistenceEngine pse, int p, byte[] binary) throws Exception {
        SvGetSessionKeyProtocol ret = new SvGetSessionKeyProtocol(binary, p);
        if (ret.getSessionId() == null || ret.getKey() == null) {
            if (ret.getSessionId() == null) {
                return new SvErrorProtocol("\u30bb\u30c3\u30b7\u30e7\u30f3ID\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            if (ret.getKey() == null) {
                return new SvErrorProtocol("\u8981\u7d20Key\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
        }
        ret.setResult(pse.get(ret.getSessionId(), ret.getKey()));
        return ret;
    }
}

