package org.maachang.session.client.net.protocol ;

import org.maachang.session.engine.PersistenceDefine;
import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;
import org.maachang.util.SerializableUtil;

/**
 * セッションIDに対して要素を取得.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class ClGetSessionKeyProtocol extends ClientProtocol {
    
    /**
     * セッションID.
     */
    private String sessionId = null ;
    
    /**
     * 要素キー名.
     */
    private String key = null ;
    
    /**
     * コンストラクタ.
     */
    public ClGetSessionKeyProtocol() {
    }
    
    /**
     * オブジェクト生成.
     */
    public void create( String sessionId,String key )
        throws Exception {
        if( sessionId == null ||
            ( sessionId = sessionId.trim() ).length() != PersistenceDefine.SESSION_KEY_LENGTH ) {
            throw new IllegalArgumentException( "指定されたセッションIDは不正です" ) ;
        }
        if( key == null || ( key = key.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "指定された要素キーは不正です" ) ;
        }
        this.sessionId = sessionId ;
        this.key = key ;
    }
    
    /**
     * オブジェクトクリア.
     */
    public void clear() {
        super.clear() ;
        sessionId = null ;
        key = null ;
    }
    
    /**
     * クライアントプロトコルタイプを取得.
     * @return int クライアントプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_GET_VALUE ;
    }
    
    /**
     * セッションIDを取得.
     * @return String セッションIDが返されます.
     */
    public String getSessionId() {
        return sessionId ;
    }
    
    /**
     * 要素キー名を取得.
     * @return String 要素キー名が返されます.
     */
    public String getKey() {
        return key ;
    }
    
    /**
     * 送信データを作成.
     * @return value 送信データが返されます.
     * @exception Exception 例外.
     */
    public byte[] getSendData() throws Exception {
        ArrayBinary b = new ArrayBinary( 150 ) ;
        b.write( ConvertParam.convertInt( getProtocolType() ) ) ;
        byte[] valBin = sessionId.getBytes( "UTF8" ) ;
        b.write( ConvertParam.convertInt( valBin.length ) ) ;
        b.write( valBin ) ;
        valBin = key.getBytes( "UTF8" ) ;
        b.write( ConvertParam.convertInt( valBin.length ) ) ;
        b.write( valBin ) ;
        return b.getBinary() ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @param p オフセット値を設定します.
     */
    public void setResult( byte[] value,int p ) throws Exception {
        int len = ConvertParam.convertInt( p,value ) ;
        if( len <= 0 ) {
            this.result = null ;
        }
        else {
            len -= 1 ;
            p += 4 ;
            int type = ( int )( value[ p ] & 0x000000ff ) ;
            p += 1 ;
            byte[] b = new byte[ len ] ;
            System.arraycopy( value,p,b,0,len ) ;
            if( type == VALUE_TYPE_STRING ) {
                this.result = new String( b,"UTF8" ) ;
            }
            else if( type == VALUE_TYPE_BINARY ) {
                this.result = b ;
            }
            else if( type == ClientProtocol.VALUE_TYPE_OBJECT ) {
                this.result = SerializableUtil.toObject( b ) ;
            }
            else {
                this.result = null ;
            }
        }
    }
}

