/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.maachang.connector.ClientConnector;
import org.maachang.dbm.engine.MDbmEngine;
import org.maachang.util.ConvertParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MDbmClientConnection {
    private static final String NOT_ACCESS = "\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u63a5\u7d9a\u304c\u78ba\u7acb\u3057\u3066\u3044\u307e\u305b\u3093";
    private ClientConnector conns = null;
    private long sessionId = -1L;

    private MDbmClientConnection() {
    }

    public MDbmClientConnection(ClientConnector conns) throws Exception {
        if (conns == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        long ss = this.readSessionId(conns);
        if (ss <= 0L) {
            throw new IOException("\u30bb\u30c3\u30b7\u30e7\u30f3ID\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.conns = conns;
        this.sessionId = ss;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)1));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (this.conns != null) {
            this.conns.close();
        }
    }

    public ClientConnector getConnector() {
        return this.conns;
    }

    public void commit() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)2));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 1) {
            throw new IOException("[commit]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
    }

    public void rollback() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)3));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 1) {
            throw new IOException("[rollback]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
    }

    public void check() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)4));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 1) {
            throw new IOException("[check]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
    }

    public void put(byte[] key, byte[] value) throws Exception {
        if (key == null || key.length <= 0 || key.length > MDbmEngine.MAX_KEY_LENGTH) {
            if (key == null || key.length <= 0) {
                throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u6700\u5927\u9577[" + MDbmEngine.MAX_KEY_LENGTH + "\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u8981\u7d20\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)17));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        o.write(ConvertParam.convertInt((int)key.length));
        o.write(key);
        o.write(ConvertParam.convertInt((int)value.length));
        o.write(value);
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 1) {
            throw new IOException("[put]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
    }

    public void remove(byte[] key) throws Exception {
        if (key == null || key.length <= 0 || key.length > MDbmEngine.MAX_KEY_LENGTH) {
            if (key == null || key.length <= 0) {
                throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u6700\u5927\u9577[" + MDbmEngine.MAX_KEY_LENGTH + "\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)18));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        o.write(ConvertParam.convertInt((int)key.length));
        o.write(key);
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 1) {
            throw new IOException("[remove]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
    }

    public byte[] get(byte[] key) throws Exception {
        if (key == null || key.length <= 0 || key.length > MDbmEngine.MAX_KEY_LENGTH) {
            if (key == null || key.length <= 0) {
                throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u6700\u5927\u9577[" + MDbmEngine.MAX_KEY_LENGTH + "\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)19));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        o.write(ConvertParam.convertInt((int)key.length));
        o.write(key);
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 17) {
            throw new IOException("[get]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return MDbmClientConnection.dataResult(b);
    }

    public boolean containsKey(byte[] key) throws Exception {
        if (key == null || key.length <= 0 || key.length > MDbmEngine.MAX_KEY_LENGTH) {
            if (key == null || key.length <= 0) {
                throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u6700\u5927\u9577[" + MDbmEngine.MAX_KEY_LENGTH + "\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)20));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        o.write(ConvertParam.convertInt((int)key.length));
        o.write(key);
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 16) {
            throw new IOException("[containsKey]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return MDbmClientConnection.booleanResult(b);
    }

    public int size() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)257));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 19) {
            throw new IOException("[size]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return MDbmClientConnection.sizeResult(b);
    }

    public String getDirectory() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)258));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 17) {
            throw new IOException("[getDirectory]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] res = MDbmClientConnection.dataResult(b);
        if (res == null) {
            return null;
        }
        return new String(res, "UTF8");
    }

    public void initKey() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)259));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 1) {
            throw new IOException("[initKey]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
    }

    public boolean hasKey() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)260));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 16) {
            throw new IOException("[hasKey]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return MDbmClientConnection.booleanResult(b);
    }

    public ArrayList<byte[]> getKey() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)261));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 18) {
            throw new IOException("[getKey]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return MDbmClientConnection.dataResultKey(b);
    }

    public long sequenceId(int no) throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)513));
        o.write(ConvertParam.convertLong((long)this.sessionId));
        o.write(ConvertParam.convertInt((int)no));
        byte[] b = MDbmClientConnection.sendRecv(this.conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 20) {
            throw new IOException("[sequenceId]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return MDbmClientConnection.idResult(b);
    }

    private long readSessionId(ClientConnector conns) throws Exception {
        OutputStream o = MDbmClientConnection.getOutputStream();
        o.write(ConvertParam.convertInt((int)514));
        byte[] b = MDbmClientConnection.sendRecv(conns, o);
        o = null;
        if (MDbmClientConnection.resultType(b) != 20) {
            throw new IOException("[sessionId]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return MDbmClientConnection.idResult(b);
    }

    public boolean isUse() {
        boolean ret = true;
        try {
            if (this.conns == null || this.conns.isClosed()) {
                ret = false;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private static final int getType(byte[] bin) throws Exception {
        if (bin == null || bin.length < 12) {
            throw new IOException("\u4e0d\u6b63\u306a\u30d7\u30ed\u30c8\u30b3\u30eb\u3067\u3059");
        }
        return ConvertParam.convertInt((int)8, (byte[])bin);
    }

    private static final int resultType(byte[] bin) throws Exception {
        int type = MDbmClientConnection.getType(bin);
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                throw new IOException(MDbmClientConnection.errorResult(bin));
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
        }
        throw new IOException("\u4e0d\u6b63\u306a\u6761\u4ef6(" + type + ")\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
    }

    private static final String errorResult(byte[] bin) throws Exception {
        int len = ConvertParam.convertInt((int)12, (byte[])bin);
        int all = 16 + len;
        if (all != bin.length) {
            throw new IOException("[error]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        byte[] b = new byte[len];
        System.arraycopy(bin, 16, b, 0, len);
        return new String(b, "UTF8");
    }

    private static final boolean booleanResult(byte[] bin) throws Exception {
        int all = 13;
        if (all != bin.length) {
            throw new IOException("[boolean]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        return ConvertParam.convertBoolean((int)12, (byte[])bin);
    }

    private static final int sizeResult(byte[] bin) throws Exception {
        int all = 16;
        if (all != bin.length) {
            throw new IOException("[int]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        return ConvertParam.convertInt((int)12, (byte[])bin);
    }

    private static final long idResult(byte[] bin) throws Exception {
        int all = 20;
        if (all != bin.length) {
            throw new IOException("[long]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        return ConvertParam.convertLong((int)12, (byte[])bin);
    }

    private static final byte[] dataResult(byte[] bin) throws Exception {
        int len = ConvertParam.convertInt((int)12, (byte[])bin);
        int all = 16 + len;
        if (all != bin.length) {
            throw new IOException("[data]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        if (len <= 0) {
            return null;
        }
        byte[] ret = new byte[len];
        System.arraycopy(bin, 16, ret, 0, len);
        return ret;
    }

    private static final ArrayList<byte[]> dataResultKey(byte[] bin) throws Exception {
        int len = ConvertParam.convertInt((int)12, (byte[])bin);
        int pos = 16;
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        int i = 0;
        while (i < len) {
            int bLen = ConvertParam.convertInt((int)pos, (byte[])bin);
            byte[] b = new byte[bLen];
            System.arraycopy(bin, pos += 4, b, 0, bLen);
            pos += bLen;
            ret.add(b);
            ++i;
        }
        return ret;
    }

    private static final OutputStream getOutputStream() throws Exception {
        return new ByteArrayOutputStream();
    }

    private static final byte[] sendRecv(ClientConnector conns, OutputStream data) throws Exception {
        byte[] b = ((ByteArrayOutputStream)data).toByteArray();
        return conns.sendReceive(b);
    }
}

