/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPBinary {
    private static final int BUF_LENGTH = 1024;
    private static final GZIPBinary SNGL = new GZIPBinary();

    private GZIPBinary() {
    }

    public static final GZIPBinary getInstance() {
        return SNGL;
    }

    public final byte[] convertBinaryByGZIP(byte[] binary) throws IllegalArgumentException, IOException {
        if (binary == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return this.convertBinaryByGZIP(binary, 0, binary.length);
    }

    public final byte[] convertBinaryByGZIP(byte[] binary, int length) throws IllegalArgumentException, IOException {
        if (binary == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return this.convertBinaryByGZIP(binary, 0, length);
    }

    public final byte[] convertBinaryByGZIP(byte[] binary, int offset, int length) throws IllegalArgumentException, IOException {
        int len;
        ByteArrayOutputStream bin = null;
        DeflaterOutputStream zip = null;
        FilterOutputStream buf = null;
        byte[] ret = null;
        if (binary == null || (len = binary.length) <= 0 || offset < 0 || offset > len || length <= 0 || length > len || offset + length > len) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            bin = new ByteArrayOutputStream();
            zip = new GZIPOutputStream(bin);
            buf = new BufferedOutputStream(zip);
            ((BufferedOutputStream)buf).write(binary, offset, length);
            ((BufferedOutputStream)buf).flush();
            ((GZIPOutputStream)zip).finish();
            ret = bin.toByteArray();
        }
        finally {
            try {
                bin.close();
            }
            catch (Exception exception) {}
            try {
                zip.close();
            }
            catch (Exception exception) {}
            try {
                buf.close();
            }
            catch (Exception exception) {}
            bin = null;
            buf = null;
            zip = null;
        }
        return ret;
    }

    public final byte[] convertGZIPByBinary(byte[] zbin) throws IllegalArgumentException, IOException {
        if (zbin == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return this.convertGZIPByBinary(zbin, 0, zbin.length);
    }

    public final byte[] convertGZIPByBinary(byte[] zbin, int length) throws IllegalArgumentException, IOException {
        if (zbin == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return this.convertGZIPByBinary(zbin, 0, length);
    }

    public final byte[] convertGZIPByBinary(byte[] zbin, int offset, int length) throws IllegalArgumentException, IOException {
        int len;
        ByteArrayInputStream bIn = null;
        ByteArrayOutputStream bOut = null;
        GZIPInputStream zip = null;
        BufferedInputStream buf = null;
        byte[] tmp = null;
        byte[] ret = null;
        if (zbin == null || (len = zbin.length) <= 0 || offset < 0 || offset > len || length <= 0 || length > len || offset + length > len) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            bIn = new ByteArrayInputStream(zbin, offset, length);
            bOut = new ByteArrayOutputStream();
            zip = new GZIPInputStream(bIn);
            buf = new BufferedInputStream(zip);
            tmp = new byte[1024];
            while ((len = buf.read(tmp)) >= 0) {
                bOut.write(tmp, 0, len);
            }
            bOut.flush();
            ret = bOut.toByteArray();
        }
        finally {
            try {
                zip.close();
            }
            catch (Exception exception) {}
            try {
                buf.close();
            }
            catch (Exception exception) {}
            try {
                bIn.close();
            }
            catch (Exception exception) {}
            try {
                bOut.close();
            }
            catch (Exception exception) {}
            bIn = null;
            bOut = null;
            zip = null;
            buf = null;
            tmp = null;
        }
        return ret;
    }
}

