package org.maachang.dbm.service ;

import java.io.IOException;
import java.net.InetAddress;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.connector.ConnectorManager;
import org.maachang.connector.ConnectorService;
import org.maachang.dbm.MDbmManager;


/**
 * MDBMサーバサービス.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since MaachangDBM 1.10
 */
public class MDbmServerService {
    
    /**
     * ログ出力.
     */
    private static final Log LOG = LogFactory.getLog( MDbmServerService.class ) ;
    
    /**
     * コネクターサービス.
     */
    private ConnectorService service = null ;
    
    /**
     * バインドアドレス.
     */
    private InetAddress addr = null ;
    
    /**
     * バインドポート.
     */
    private int port = -1 ;
    
    /**
     * コンストラクタ.
     */
    private MDbmServerService() {
    }
    
    /**
     * コンストラクタ.
     * @param addr 対象のバインドアドレスを設定します.
     * @param port 対象のバインドポートを設定します.
     * @param max 対象の最大接続数を設定します.
     * @param pool 対象のプーリング数を設定します.
     * @exception Exception 例外.
     */
    public MDbmServerService( InetAddress addr,int port,int max,int pool )
        throws Exception {
        createObject( addr,port,max,pool ) ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        destroy() ;
    }
    
    /**
     * オブジェクトを破棄.
     */
    public void destroy() {
        if( service != null ) {
            LOG.info( "## MDbmServerService - 破棄" ) ;
            service.destroy() ;
        }
    }
    
    /**
     * オブジェクト生成.
     */
    private void createObject( InetAddress addr,int port,int max,int pool )
        throws Exception {
        if( MDbmManager.getInstance().isClose() == true ) {
            throw new IOException( "MaachangDbmは開始していません" ) ;
        }
        if( port <= -1 || port >= 65536 ) {
            port = ProtocolDef.BIND_PORT ;
        }
        if( max <= 0 ) {
            max = ProtocolDef.MAX_CONNECT ;
        }
        if( pool <= 0 ) {
            pool = ProtocolDef.POOL_LENGTH ;
        }
        if( addr != null ) {
            LOG.info( "## MDbmServerService - 生成[ addr:" + addr.getHostAddress() +
                " port:" + port + " max:" + max + " pool:" + pool + "]" ) ;
        }
        else {
            LOG.info( "## MDbmServerService - 生成[ addr:0.0.0.0" +
                " port:" + port + " max:" + max + " pool:" + pool + "]" ) ;
        }
        ConnectorManager man = new ConnectorManager( addr,port,max ) ;
        MDbmCallback call = new MDbmCallback( MDbmManager.getInstance().getMDbm( false ) ) ;
        ConnectorService sv = new ConnectorService( ProtocolDef.PROTOCOL_HEADER,
            call,man,pool ) ;
        this.service = sv ;
        this.addr = man.getServerSocket().getInetAddress() ;
        this.port = man.getServerSocket().getLocalPort() ;
    }
    
    /**
     * バインドアドレスを取得.
     * <BR>
     * @return InetAddress バインドアドレスが返されます.
     */
    public InetAddress getInetAddress() {
        return addr ;
    }
    
    /**
     * バインドポートを取得.
     * <BR>
     * @return int バインドポートが返されます.
     */
    public int getLocalPort() {
        return port ;
    }
}
