/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import org.maachang.conf.Config;
import org.maachang.conf.ConvIniParam;
import org.maachang.conf.ReadIni;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.MDbmOp;
import org.maachang.dbm.engine.MDbmDefine;
import org.maachang.dbm.service.client.MDbmDriverManager;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MDbmCommand {
    private boolean consoleOut = true;

    private MDbmCommand() {
    }

    public static final void main(String[] args) throws Exception {
        MDbmDefine.OUT_MODE = false;
        String opt = "-L";
        if (args == null || args.length <= 0) {
            opt = "-L";
        } else {
            opt = args[0];
            opt = opt.trim().toUpperCase();
        }
        if (opt.equals("?") || opt.equals("HELP") || !opt.equals("-L") && !opt.equals("-R")) {
            System.out.println("MDBM\u64cd\u4f5c\u30b3\u30de\u30f3\u30c9");
            System.out.println();
            System.out.println("mdcmd [opt]");
            System.out.println("[opt] \u63a5\u7d9a\u30e2\u30fc\u30c9\u3092\u8a2d\u5b9a\u3057\u307e\u3059.");
            System.out.println("      -L \u30ed\u30fc\u30ab\u30eb\u63a5\u7d9a\u3067\u751f\u6210\u3057\u307e\u3059.");
            System.out.println("      -R \u30ea\u30e2\u30fc\u30c8\u63a5\u7d9a\u3067\u751f\u6210\u3057\u307e\u3059.");
            return;
        }
        new MDbmCommand().execution(opt, args);
    }

    private static final MDbmOp localMDBM() throws Exception {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("./conf/mdbm.conf"), "UTF8"));
            Config conf = new Config();
            ReadIni.analisys((Config)conf, (BufferedReader)br);
            br.close();
            br = null;
            MDbmManager.getInstance().open(conf.get("mdbm", "directory", 0));
            MDbmOp mDbmOp = MDbmManager.getInstance().getMDbmOp();
            return mDbmOp;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final MDbmOp removeMDBM() throws Exception {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("./conf/mdbm.conf"), "UTF8"));
            Config conf = new Config();
            ReadIni.analisys((Config)conf, (BufferedReader)br);
            br.close();
            br = null;
            if (conf.isKeys("mdbm", "flag") && !ConvIniParam.getBoolean((String)conf.get("mdbm", "flag", 0))) {
                throw new IOException("\u63a5\u7d9a\u30e2\u30fc\u30c9\u306fOFF\u306b\u306a\u3063\u3066\u3044\u307e\u3059");
            }
            MDbmOp mDbmOp = MDbmDriverManager.getConnectionOp(InetAddress.getByName("127.0.0.1"), conf.getInt("mdbm", "bind-port", 0));
            return mDbmOp;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void execution(String opt, String[] args) throws Exception {
        this.println("[ MDBM Command ]");
        String connMode = "";
        MDbmOp op = null;
        if ("-L".equals(opt)) {
            this.println("[Local]\u63a5\u7d9aMode.");
            op = MDbmCommand.localMDBM();
            connMode = "L";
        } else if ("-R".equals(opt)) {
            this.println("[Remote]\u63a5\u7d9aMode.");
            op = MDbmCommand.removeMDBM();
            connMode = "R";
        }
        this.println();
        if (args.length > 1) {
            StringBuilder buf = new StringBuilder();
            int len = args.length;
            int i = 1;
            while (i < len) {
                if (i != 1) {
                    buf.append(" ");
                }
                buf.append(args[i]);
                ++i;
            }
            String s = buf.toString();
            buf = null;
            this.executionOneLine(op, s);
        } else {
            String input;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            do {
                this.print(String.valueOf(connMode) + "$mdbm>");
            } while (!this.executionOneLine(op, input = br.readLine()));
        }
        op.close();
    }

    private boolean executionOneLine(MDbmOp op, String input) {
        block27: {
            try {
                if (input == null || (input = input.trim()).length() <= 0) {
                    return false;
                }
                ArrayList lst = StringUtil.getCsv((boolean)false, (String)input, (String)" ");
                if (lst == null || lst.size() <= 0) {
                    return false;
                }
                String cmd = (String)lst.get(0);
                if (cmd == null || (cmd = cmd.trim()).length() <= 0) {
                    return false;
                }
                if ("get".equals(cmd = cmd.toLowerCase())) {
                    this.cmdGet(op, lst);
                } else if ("key".equals(cmd)) {
                    this.cmdKey(op, lst);
                } else if ("mask".equals(cmd)) {
                    this.cmdMask(op, lst);
                } else if ("set".equals(cmd) || "put".equals(cmd)) {
                    this.cmdSet(op, lst);
                } else if ("remove".equals(cmd)) {
                    this.cmdRemove(op, lst);
                } else if ("commit".equals(cmd)) {
                    op.commit();
                } else if ("rollback".equals(cmd)) {
                    op.rollback();
                } else if ("size".equals(cmd)) {
                    this.cmdSize(op);
                } else if ("cls".equals(cmd) || "clear".equals(cmd)) {
                    int x = 0;
                    while (x < 80) {
                        this.println();
                        ++x;
                    }
                } else if ("?".equals(cmd) || "help".equals(cmd)) {
                    this.println(" get [key] $[FILE_NAME] \u8981\u7d20\u53d6\u5f97");
                    this.println(" key [start] [end] Key\u4e00\u89a7\u53d6\u5f97");
                    this.println(" mask [key] [start] [end] \u30de\u30b9\u30af\u3067Key\u4e00\u89a7\u53d6\u5f97");
                    this.println(" set/put [key] ([value] or $[FILE_NAME]) \u8981\u7d20\u8a2d\u5b9a");
                    this.println(" remove [key] Key\u524a\u9664");
                    this.println(" size \u683c\u7d0d\u60c5\u5831\u6570\u53d6\u5f97");
                    this.println(" commit \u30b3\u30df\u30c3\u30c8\u51e6\u7406");
                    this.println(" rollback \u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u51e6\u7406");
                    this.println(" exit/quit \u30b3\u30de\u30f3\u30c9\u7d42\u4e86");
                    this.println(" cls/clear \u753b\u9762\u30af\u30ea\u30a2");
                    this.println(" ?/help \u30d8\u30eb\u30d7\u753b\u9762\u8868\u793a");
                    this.println();
                    this.println("get\u3068set\u306b\u5bfe\u3057\u3066\u3001\u203b1:$[FILE_NAME]\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u3067\u3001");
                    this.println("\u30d5\u30a1\u30a4\u30ebI/O\u3067\u51e6\u7406\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059.");
                    this.println();
                    this.println("\u203b1:\u305f\u3068\u3048\u3070\u3001c:\\out\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u6271\u3046\u5834\u5408\u306f");
                    this.println(" $[c:\\out]");
                    this.println("\u306e\u3088\u3046\u306b\u8a2d\u5b9a\u3057\u307e\u3059.");
                    this.println();
                } else {
                    if ("exit".equals(cmd) || "quit".equals(cmd)) {
                        this.println("\u7d42\u4e86\u3057\u307e\u3059");
                        return true;
                    }
                    this.printErr(String.valueOf(cmd) + ":\u30b3\u30de\u30f3\u30c9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
            }
            catch (Exception e) {
                if (!this.consoleOut) break block27;
                e.printStackTrace();
            }
        }
        return false;
    }

    private void cmdGet(MDbmOp op, ArrayList<String> in) throws Exception {
        if (in.size() < 2) {
            this.printErr("get:\u30ad\u30fc\u540d\u304c\u53d6\u5f97\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        String key = in.get(1);
        key = key.trim();
        if (!op.containsKey(key = this.cutCote(key))) {
            this.printErr("get: key[" + key + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            return;
        }
        String fileName = null;
        if (in.size() >= 3) {
            fileName = in.get(2);
            if (fileName == null || (fileName = fileName.trim()).length() <= 0) {
                fileName = null;
            } else if (fileName.startsWith("$[") && fileName.endsWith("]")) {
                fileName = fileName.substring(2, fileName.length() - 1);
                fileName = this.cutCote(fileName);
            }
        }
        if (fileName == null) {
            String s = op.getString(key);
            if (s == null) {
                this.printErr("get: key[" + key + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            } else {
                this.println(s);
            }
        } else {
            byte[] b = op.get(key);
            if (b == null || b.length <= 0) {
                this.printErr("get: key[" + key + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            } else {
                FileUtil.setFile((String)fileName, (byte[])b);
            }
        }
    }

    private void cmdKey(MDbmOp op, ArrayList<String> in) throws Exception {
        int start = -1;
        int end = -1;
        if (in.size() >= 2) {
            start = ConvIniParam.getInt((String)in.get(1));
            if (in.size() >= 3) {
                end = ConvIniParam.getInt((String)in.get(2));
            }
        }
        if (start <= 0) {
            start = 0;
        }
        if (end <= 0) {
            end = Integer.MAX_VALUE;
        }
        this.viewNormalKey(op, start, end);
    }

    private void cmdMask(MDbmOp op, ArrayList<String> in) throws Exception {
        String mask = null;
        int start = -1;
        int end = -1;
        boolean noargsFlag = false;
        if (in.size() < 2) {
            noargsFlag = true;
        } else {
            mask = in.get(1);
            if (mask == null || (mask = mask.trim()).length() <= 0) {
                noargsFlag = true;
            }
            if (in.size() >= 3) {
                start = ConvIniParam.getInt((String)in.get(1));
                if (in.size() >= 4) {
                    end = ConvIniParam.getInt((String)in.get(2));
                }
            }
        }
        if (start <= 0) {
            start = 0;
        }
        if (end <= 0) {
            end = Integer.MAX_VALUE;
        }
        if (noargsFlag) {
            this.viewNormalKey(op, start, end);
        } else {
            this.viewMasklKey(op, mask, start, end);
        }
    }

    private void cmdSet(MDbmOp op, ArrayList<String> in) throws Exception {
        if (in.size() < 2) {
            this.printErr("set:\u30ad\u30fc\u540d\u304c\u53d6\u5f97\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        if (in.size() < 3) {
            this.printErr("set:\u8981\u7d20\u304c\u53d6\u5f97\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        String key = in.get(1);
        if (key == null || (key = key.trim()).length() <= 0) {
            this.printErr("set:\u30ad\u30fc\u540d\u304c\u53d6\u5f97\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        } else {
            key = this.cutCote(key);
        }
        byte[] valBin = null;
        String val = in.get(2);
        if (val == null || (val = val.trim()).length() <= 0) {
            this.printErr("set:\u8981\u7d20\u304c\u53d6\u5f97\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (val.startsWith("$[") && val.endsWith("]")) {
            val = val.substring(2, val.length() - 1);
            val = this.cutCote(val);
            valBin = FileUtil.getFile((String)val);
            val = null;
        } else {
            valBin = val.getBytes("UTF8");
            val = null;
        }
        if (valBin == null || valBin.length <= 0) {
            this.printErr("set:\u8981\u7d20\u304c\u53d6\u5f97\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (op.containsKey(key)) {
            this.println("set: key[" + key + "]\u3092\u4e0a\u66f8\u304d\u3057\u307e\u3059");
        }
        op.put(key, valBin);
        this.println("set: key[" + key + "]\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f.");
    }

    private void cmdRemove(MDbmOp op, ArrayList<String> in) throws Exception {
        if (in.size() < 2) {
            this.printErr("remove:\u30ad\u30fc\u540d\u304c\u53d6\u5f97\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        String key = in.get(1);
        key = key.trim();
        if (!op.containsKey(key = this.cutCote(key))) {
            this.printErr("remove: key[" + key + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            return;
        }
        op.remove(key);
        this.println("remove: key[" + key + "]\u3092\u524a\u9664\u3057\u307e\u3057\u305f.");
    }

    private void cmdSize(MDbmOp op) throws Exception {
        this.println(String.valueOf(op.size()));
    }

    /*
     * Unable to fully structure code
     */
    private void viewNormalKey(MDbmOp op, int start, int end) throws Exception {
        cnt = 0;
        e = op.elements();
        if (e != null) ** GOTO lbl9
        return;
        while (cnt < start) {
            e.nextElement();
            ++cnt;
lbl9:
            // 2 sources

            if (e.hasMoreElements()) continue;
        }
        if (cnt < start) {
            return;
        }
        cnt = 0;
        while (e.hasMoreElements()) {
            if (cnt >= end) break;
            b = e.nextElement();
            this.println("[" + (start + cnt) + "]:" + new String(b, "UTF8"));
            ++cnt;
        }
    }

    private void viewMasklKey(MDbmOp op, String mask, int start, int end) throws Exception {
        String s;
        byte[] b;
        int cnt = 0;
        Enumeration<byte[]> e = op.elements();
        while (e.hasMoreElements()) {
            if (cnt >= start) break;
            b = e.nextElement();
            s = new String(b, "UTF8");
            if (s.indexOf(mask) < 0) continue;
            ++cnt;
        }
        if (cnt < start) {
            return;
        }
        cnt = 0;
        while (e.hasMoreElements()) {
            if (cnt >= end) break;
            b = e.nextElement();
            s = new String(b, "UTF8");
            if (s.indexOf(mask) < 0) continue;
            this.println("[" + cnt + "]:" + s);
            ++cnt;
        }
    }

    private String cutCote(String s) {
        if (s.startsWith("'") && s.endsWith("'")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private void print(String s) {
        if (this.consoleOut) {
            System.out.print(s);
        }
    }

    private void println() {
        if (this.consoleOut) {
            System.out.println();
        }
    }

    private void println(String s) {
        if (this.consoleOut) {
            System.out.println(s);
        }
    }

    private void printErr(String s) {
        if (this.consoleOut) {
            System.out.println(s);
        }
    }
}

