/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet;

import org.maachang.util.FileUtil;

public class Project {
    private Project() {
    }

    public static final void main(String[] args) throws Exception {
        new Project().execution(args);
    }

    private void execution(String[] args) throws Exception {
        if (args == null || args.length <= 0) {
            throw new IllegalArgumentException("MaachangComet\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u5fc5\u8981\u3067\u3059");
        }
        int projType = -1;
        if (args.length >= 2) {
            if ("derby".equals(args[1].trim().toLowerCase())) {
                projType = 1;
            } else if ("postgre".equals(args[1].trim().toLowerCase())) {
                projType = 2;
            } else if ("mysql".equals(args[1].trim().toLowerCase())) {
                projType = 3;
            } else if ("help".equals(args[1].trim().toLowerCase()) || "?".equals(args[1].trim().toLowerCase())) {
                System.out.println(" mproj [database]");
                System.out.println(" [database] \u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306b\u5bfe\u3059\u308b\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u8a2d\u5b9a\u3057\u307e\u3059.");
                System.out.println("            MaachangComet\u3067\u306f\u3001\u4ee5\u4e0b\u306e\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u307e\u3059.");
                System.out.println("            derby   : Apache Derby(JavaDB)\u7528\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059.");
                System.out.println("            postgre : Postgre\u7528\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059.");
                System.out.println("            mysql   : MySQL\u7528\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059.");
                System.out.println();
                System.out.println(" \u307e\u305f\u30d1\u30e9\u30e1\u30fc\u30bf\u306a\u3057\u306e\u5834\u5408\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u4f9d\u5b58\u3057\u306a\u3044\u3001\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u96db\u578b\u3092");
                System.out.println(" \u4f5c\u6210\u3057\u307e\u3059.");
                return;
            }
        }
        System.out.println("*** maachang comet - \u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u751f\u6210 - ***");
        System.out.println();
        String dir = FileUtil.getFullPath((String)".");
        if (dir.endsWith("\\") || dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "conf/"));
        System.out.println("conf/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "application/"));
        System.out.println("application/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "model/"));
        System.out.println("model/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "lib/"));
        System.out.println("lib/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "jar/"));
        System.out.println("jar/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "log/"));
        System.out.println("log/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "table/"));
        System.out.println("table/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "error/"));
        System.out.println("error/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "template/"));
        System.out.println("template/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "public/"));
        System.out.println("public/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "public/" + "img/"));
        System.out.println("public/img/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "public/" + "style/"));
        System.out.println("public/style/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "public/" + "js/"));
        System.out.println("public/js/ \u3092\u751f\u6210");
        System.out.print("...");
        FileUtil.mkdirs((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + "startup/"));
        System.out.println("startup/ \u3092\u751f\u6210");
        System.out.println();
        System.out.println("...conf/ \u5185\u5bb9\u3092\u30b3\u30d4\u30fc");
        this.copyByConfig(args[0]);
        System.out.println("...startup/ \u5185\u5bb9\u3092\u30b3\u30d4\u30fc");
        this.copyByInnerDir(args[0], "startup/");
        System.out.println("...public/ \u5185\u5bb9\u3092\u30b3\u30d4\u30fc");
        this.copyByPublic(args[0]);
        System.out.println("...public/img/ \u5185\u5bb9\u3092\u30b3\u30d4\u30fc");
        this.copyByInnerDir(args[0], "public/img/");
        System.out.println("...public/style/ \u5185\u5bb9\u3092\u30b3\u30d4\u30fc");
        this.copyByInnerDir(args[0], "public/style/");
        System.out.println("...public/js/ \u5185\u5bb9\u3092\u30b3\u30d4\u30fc");
        this.copyByInnerDir(args[0], "public/js/");
        String projName = null;
        if (projType == 1) {
            projName = "derby";
        } else if (projType == 2) {
            projName = "postgre";
        } else if (projType == 3) {
            projName = "mysql";
        }
        if (projName != null) {
            System.out.println();
            System.out.println();
            System.out.println("## " + projName + "\u7528\u30b3\u30d4\u30fc");
            this.copyDirBySrcToDest(String.valueOf(args[0]) + "/database/" + projName + "/lib/", "./jar/");
            this.copyFile(String.valueOf(args[0]) + "/database/" + projName + "/conf/record.conf", "./conf/record.conf");
        }
    }

    private final void copyByConfig(String dir) throws Exception {
        String[] lst;
        String destDir;
        if (dir.endsWith("\\") || dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if ((dir = FileUtil.getFullPath((String)(String.valueOf(dir) + "/" + "conf/"))).endsWith("\\") || dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if ((destDir = FileUtil.getFullPath((String)"./conf/")).endsWith("\\") || destDir.endsWith("/")) {
            destDir = destDir.substring(0, destDir.length() - 1);
        }
        if ((lst = FileUtil.getFileList((String)dir)) != null) {
            int len = lst.length;
            int i = 0;
            while (i < len) {
                if (lst[i] != null) {
                    System.out.print("......");
                    byte[] bin = FileUtil.getFile((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + lst[i]));
                    if (bin != null) {
                        FileUtil.setFile((String)(String.valueOf(destDir) + FileUtil.FILE_SPACE + lst[i]), (byte[])bin);
                        System.out.println(String.valueOf(lst[i]) + " \u3092\u30b3\u30d4\u30fc");
                    }
                    bin = null;
                }
                ++i;
            }
        }
    }

    private final void copyByPublic(String dir) throws Exception {
        String[] lst;
        String destDir;
        if (dir.endsWith("\\") || dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if ((dir = FileUtil.getFullPath((String)(String.valueOf(dir) + "/" + "public/"))).endsWith("\\") || dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if ((destDir = FileUtil.getFullPath((String)"./public/")).endsWith("\\") || destDir.endsWith("/")) {
            destDir = destDir.substring(0, destDir.length() - 1);
        }
        if ((lst = FileUtil.getFileList((String)dir)) != null) {
            int len = lst.length;
            int i = 0;
            while (i < len) {
                if (lst[i] != null) {
                    System.out.print("......");
                    byte[] bin = FileUtil.getFile((String)(String.valueOf(dir) + FileUtil.FILE_SPACE + lst[i]));
                    if (bin != null) {
                        FileUtil.setFile((String)(String.valueOf(destDir) + FileUtil.FILE_SPACE + lst[i]), (byte[])bin);
                        System.out.println(String.valueOf(lst[i]) + " \u3092\u30b3\u30d4\u30fc");
                    }
                    bin = null;
                }
                ++i;
            }
        }
    }

    private final void copyByInnerDir(String dir, String inner) throws Exception {
        String[] lst;
        if (dir.endsWith("\\") || dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if ((dir = FileUtil.getFullPath((String)(String.valueOf(dir) + "/" + inner))).endsWith("\\") || dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (!FileUtil.isDirExists((String)dir)) {
            return;
        }
        String destDir = FileUtil.getFullPath((String)("./" + inner));
        if (destDir.endsWith("\\") || destDir.endsWith("/")) {
            destDir = destDir.substring(0, destDir.length() - 1);
        }
        if ((lst = FileUtil.getFileList((String)dir)) != null) {
            int len = lst.length;
            int i = 0;
            while (i < len) {
                if (lst[i] != null) {
                    System.out.print("......");
                    if (this.copyFile(String.valueOf(dir) + FileUtil.FILE_SPACE + lst[i], String.valueOf(destDir) + FileUtil.FILE_SPACE + lst[i])) {
                        System.out.println(String.valueOf(lst[i]) + " \u3092\u30b3\u30d4\u30fc");
                    }
                }
                ++i;
            }
        }
    }

    private final void copyDirBySrcToDest(String src, String dest) throws Exception {
        String[] lst = FileUtil.getFileList((String)src);
        if (lst != null) {
            int len = lst.length;
            int i = 0;
            while (i < len) {
                if (lst[i] != null) {
                    this.copyFile(String.valueOf(src) + lst[i], String.valueOf(dest) + FileUtil.FILE_SPACE + lst[i]);
                }
                ++i;
            }
        }
    }

    private final boolean copyFile(String src, String dest) throws Exception {
        byte[] bin;
        if (FileUtil.isFileExists((String)src) && (bin = FileUtil.getFile((String)src)) != null) {
            FileUtil.setFile((String)dest, (byte[])bin);
            return true;
        }
        return false;
    }
}

