/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.session;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.session.HttpdSessionManager;
import org.maachang.comet.mdbm.SingleMDbm;
import org.maachang.conf.Config;
import org.maachang.conf.ReadConfigUtil;
import org.maachang.connector.EchoClientConnector;
import org.maachang.dbm.MDbm;
import org.maachang.session.client.PSessionManager;
import org.maachang.session.client.local.PSessionLocalDriver;
import org.maachang.session.client.net.PSessionNetDriver;
import org.maachang.session.engine.PersistenceDefine;
import org.maachang.util.FileUtil;

public class SessionService {
    private static final Log LOG = LogFactory.getLog(SessionService.class);
    private static final byte[] HEADER_BINARY = PersistenceDefine.PROTOCOL_HEADER;
    public static final int BIND_PORT = 3111;
    private static final String SESSION_CONF = "./conf/session.conf";

    public static final HttpdSessionManager getManager() throws Exception {
        HttpdSessionManager ret = null;
        Config conf = new Config();
        if (FileUtil.isFileExists((String)SESSION_CONF)) {
            ReadConfigUtil.readConfig((Config)conf, (String)SESSION_CONF);
            if (conf.isSection("session-client") && conf.getBoolean("session-client", "flag", 0)) {
                int port;
                InetAddress addr = conf.getInetAddress("session-client", "connect-address", 0);
                if (addr == null) {
                    addr = InetAddress.getByName("127.0.0.1");
                }
                if ((port = conf.getInt("session-client", "connect-port", 0)) <= -1) {
                    port = 3111;
                }
                if (EchoClientConnector.echo((byte[])HEADER_BINARY, (InetAddress)addr, (int)port)) {
                    PSessionManager m = PSessionNetDriver.getConnection((InetAddress)addr, (int)port);
                    if (m != null) {
                        LOG.info((Object)" ++ PSE\u30b5\u30fc\u30d0(PersistenceSession\u30b5\u30fc\u30d0)\u306b\u63a5\u7d9a");
                        LOG.info((Object)(" ++ addr:" + addr.getHostAddress() + " port:" + port));
                        ret = new HttpdSessionManager(m);
                    }
                    m = null;
                }
            }
        }
        if (ret == null) {
            LOG.info((Object)" ++ PSE\u30ed\u30fc\u30ab\u30eb\u3067\u63a5\u7d9a");
            ret = new HttpdSessionManager(PSessionLocalDriver.getConnection((MDbm)SingleMDbm.getInstance().getMDbm()));
        }
        return ret;
    }
}

