/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.client.net;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.maachang.session.client.net.ClientSessionCacheThread;

public class ClientSessionCache {
    private static final int TIMEOUT = 3500;
    private Map<String, Long> map = null;
    private ClientSessionCacheThread thread = null;

    protected ClientSessionCache() throws Exception {
        try {
            this.map = Collections.synchronizedMap(new HashMap());
            this.thread = new ClientSessionCacheThread(this.map, 3500L);
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.thread != null) {
            this.thread.stopThread();
        }
        this.thread = null;
        if (this.map != null) {
            this.map.clear();
        }
        this.map = null;
    }

    public synchronized void put(String sessionId) {
        if (this.isUse()) {
            if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
                return;
            }
            this.map.put(sessionId, new Long(System.currentTimeMillis()));
        }
    }

    public synchronized void remove(String sessionId) {
        if (!this.isUse()) {
            return;
        }
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return;
        }
        if (this.map.containsKey(sessionId)) {
            this.map.remove(sessionId);
        }
    }

    public synchronized boolean containsKey(String sessionId) {
        if (!this.isUse()) {
            return false;
        }
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return false;
        }
        if (this.map.containsKey(sessionId)) {
            this.map.put(sessionId, new Long(System.currentTimeMillis()));
            return true;
        }
        return false;
    }

    public synchronized boolean isUse() {
        return this.map != null && this.thread != null && !this.thread.isStop();
    }
}

