/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.client.net;

import org.maachang.connector.ClientConnector;
import org.maachang.session.client.PSession;
import org.maachang.session.client.PSessionManager;
import org.maachang.session.client.net.ClientSessionCache;
import org.maachang.session.client.net.PSessionNetImpl;
import org.maachang.session.client.net.protocol.ClCreateSessionIdProtocol;
import org.maachang.session.client.net.protocol.ClDeleteSessionIdProtocol;
import org.maachang.session.client.net.protocol.ClDeleteSessionTimeProtocol;
import org.maachang.session.client.net.protocol.ClUseSessionIdProtocol;
import org.maachang.session.client.net.protocol.ClUseToSessionIdProtocol;
import org.maachang.session.client.net.protocol.IOClientProtocol;

class PSessionNetManagerImpl
implements PSessionManager {
    private ClientConnector conn = null;
    private ClientSessionCache cache = null;
    private long deleteTime = -1L;
    private final ClCreateSessionIdProtocol createSession = new ClCreateSessionIdProtocol();
    private final ClDeleteSessionIdProtocol removeSession = new ClDeleteSessionIdProtocol();
    private final ClUseSessionIdProtocol isSession = new ClUseSessionIdProtocol();
    private final ClDeleteSessionTimeProtocol deleteSessionTime = new ClDeleteSessionTimeProtocol();
    private final ClUseToSessionIdProtocol useToSession = new ClUseToSessionIdProtocol();

    public PSessionNetManagerImpl(ClientConnector conn) throws Exception {
        if (conn == null) {
            throw new IllegalArgumentException("\u30b3\u30cd\u30af\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        ClientSessionCache cache = new ClientSessionCache();
        this.conn = conn;
        this.cache = cache;
    }

    protected void finalize() throws Exception {
        this.conn = null;
    }

    public String createSession() throws Exception {
        this.createSession.clear();
        String ret = null;
        try {
            IOClientProtocol.execution(this.conn, this.createSession, 7);
            ret = (String)this.createSession.getResult();
            if (ret != null && ret.length() == 48) {
                this.cache.put(ret);
            }
        }
        finally {
            this.createSession.clear();
        }
        return ret;
    }

    public PSession getSession() throws Exception {
        return this.getSession(null);
    }

    public PSession getSession(String sessionId) throws Exception {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            sessionId = null;
        }
        if (this.cache.containsKey(sessionId)) {
            return new PSessionNetImpl(sessionId, this.conn);
        }
        if ((sessionId = this.useToSessionId(sessionId)) != null && sessionId.length() == 48) {
            this.cache.put(sessionId);
        }
        return new PSessionNetImpl(sessionId, this.conn);
    }

    public void reomveSession(String sessionId) throws Exception {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return;
        }
        this.cache.remove(sessionId);
        this.removeSession.clear();
        this.removeSession.create(sessionId);
        try {
            IOClientProtocol.execution(this.conn, this.removeSession, 7);
        }
        finally {
            this.removeSession.clear();
        }
    }

    public boolean isSession(String sessionId) throws Exception {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return false;
        }
        if (this.cache.containsKey(sessionId)) {
            return true;
        }
        this.isSession.clear();
        this.isSession.create(sessionId);
        boolean ret = false;
        try {
            IOClientProtocol.execution(this.conn, this.isSession, 7);
            Object v = this.isSession.getResult();
            if (v != null) {
                ret = (Boolean)v;
            }
        }
        finally {
            this.isSession.clear();
        }
        return ret;
    }

    public long getDeleteSessionTime() throws Exception {
        if (this.deleteTime > 0L) {
            return this.deleteTime;
        }
        this.deleteSessionTime.clear();
        long ret = -1L;
        try {
            IOClientProtocol.execution(this.conn, this.deleteSessionTime, 7);
            Object v = this.deleteSessionTime.getResult();
            if (v != null) {
                this.deleteTime = ret = ((Long)v).longValue();
            }
        }
        finally {
            this.deleteSessionTime.clear();
        }
        return ret;
    }

    private String useToSessionId(String sessionId) throws Exception {
        if (sessionId == null) {
            return this.createSession();
        }
        this.useToSession.clear();
        this.useToSession.create(sessionId);
        String ret = null;
        try {
            IOClientProtocol.execution(this.conn, this.useToSession, 7);
            Object v = this.useToSession.getResult();
            if (v != null) {
                ret = (String)v;
            }
        }
        finally {
            this.useToSession.clear();
        }
        return ret;
    }
}

