/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.client.net.protocol;

import org.maachang.session.client.net.protocol.ClientProtocol;
import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;
import org.maachang.util.SerializableUtil;

public class ClGetSessionKeyProtocol
extends ClientProtocol {
    private String sessionId = null;
    private String key = null;

    public void create(String sessionId, String key) throws Exception {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u30bb\u30c3\u30b7\u30e7\u30f3ID\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key == null || (key = key.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u8981\u7d20\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.sessionId = sessionId;
        this.key = key;
    }

    public void clear() {
        super.clear();
        this.sessionId = null;
        this.key = null;
    }

    public int getProtocolType() {
        return 274;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getKey() {
        return this.key;
    }

    public byte[] getSendData() throws Exception {
        ArrayBinary b = new ArrayBinary(150);
        b.write(ConvertParam.convertInt((int)this.getProtocolType()));
        byte[] valBin = this.sessionId.getBytes("UTF8");
        b.write(ConvertParam.convertInt((int)valBin.length));
        b.write(valBin);
        valBin = this.key.getBytes("UTF8");
        b.write(ConvertParam.convertInt((int)valBin.length));
        b.write(valBin);
        return b.getBinary();
    }

    public void setResult(byte[] value, int p) throws Exception {
        int len = ConvertParam.convertInt((int)p, (byte[])value);
        if (len <= 0) {
            this.result = null;
        } else {
            int type = value[p += 4] & 0xFF;
            byte[] b = new byte[--len];
            System.arraycopy(value, ++p, b, 0, len);
            this.result = type == 1 ? new String(b, "UTF8") : (type == 2 ? (Object)b : (type == 3 ? SerializableUtil.toObject((byte[])b) : null));
        }
    }
}

