package org.maachang.comet.mdbm;

import java.net.InetAddress;

import org.maachang.comet.conf.IniFile;
import org.maachang.comet.conf.ServiceDef;
import org.maachang.conf.ConvIniParam;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmIO;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.client.MDbmDriverManager;
import org.maachang.manager.GlobalManager;


/**
 * 1つのMDBMオブジェクトを管理するシングルトン.
 * 
 * @version 2008/05/21
 * @author masahito suzuki
 * @since MaachangComet 1.16
 */
public class SingleMDbm {
    private static final SingleMDbm SNGL = new SingleMDbm() ;
    private MDbm mdbm = null ;
    
    private SingleMDbm() {}
    
    /**
     * オブジェクトを取得.
     * @return SingleMDbm オブジェクトが返されます.
     */
    public static final SingleMDbm getInstance() {
        return SNGL ;
    }
    
    /**
     * MDbmオブジェクト生成.
     * @param console [true]の場合、コンソール接続で、リモート接続モードで生成します.
     * @param mode [true]の場合、トランザクションモードをで生成します.<br>
     *             また、[console==true]の場合、この条件は無視されます.
     * @return boolean [true]の場合、生成に成功しました.
     * @exception Exception 例外.
     */
    public boolean createMDbm( boolean console )
        throws Exception {
        return privateCreateMDbm( console ) ;
    }
    
    /**
     * MDBMオブジェクトを取得.
     * @return MDbm MDBMオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public MDbm getMDbm()
        throws Exception {
        return privateGetMDbm() ;
    }
    
    /**
     * MDBMオブジェクトを取得.
     * @param mode [true]の場合、トランザクションモードで返します.
     * @return MDbm MDBMオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public MDbm getMDbm( boolean mode )
        throws Exception {
        MDbm mdbm = privateGetMDbm() ;
        if( mdbm instanceof MDbmIO ) {
            mdbm = MDbmManager.getInstance().getTransaction( mdbm ) ;
        }
        return mdbm ;
    }
    
    /**
     * MDBMが生成されているかチェック.
     * @return boolean [false]の場合、MDBMは生成されていません.
     */
    public boolean isCreate() {
        return ( privateGetMDbm() != null ) ;
    }
    
    /**
     * トランザクションモードを取得.
     */
    
    private synchronized boolean privateCreateMDbm( boolean console )
        throws Exception {
        if( this.mdbm == null ) {
            if( console == false ) {
                this.mdbm = MDbmManager.getInstance().getMDbm() ;
            }
            else {
                IniFile config = ( IniFile )GlobalManager.getInstance().get(
                        ServiceDef.MANAGER_BY_CONFIG ) ;
                if( ConvIniParam.getBoolean( config.get( "mdbm","flag",0 ) ) == true ) {
                    InetAddress addr = ConvIniParam.getInetAddress( config.get( "mdbm","bind-addr",0 ) ) ;
                    int port = ConvIniParam.getInt( config.get( "mdbm","bind-port",0 ) ) ;
                    if( addr == null ) {
                        addr = InetAddress.getByName( "127.0.0.1" ) ;
                    }
                    if( port <= -1 ) {
                        port = -1 ;
                    }
                    this.mdbm = MDbmDriverManager.getConnection( addr,port ) ;
                }
            }
            return true ;
        }
        return false ;
    }
    
    private synchronized MDbm privateGetMDbm() {
        return this.mdbm ;
    }
}
