/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.connector;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.util.ConvertParam;

public class ConnectorSession {
    private static final Log LOG = LogFactory.getLog(ConnectorSession.class);
    public static final int RECEIVE_TIMEOUT = 2500;
    protected static final long SESSION_TIMEOUT = 30000L;
    protected static final String LOCAL_HOST = "127.0.0.1";
    private static final int BUFFER = 131072;
    private static final int LINGER = 5;
    private long updateTime = -1L;
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private InetAddress connectAddress = null;
    private int connectPort = -1;
    private byte[] headerBinary = null;

    private ConnectorSession() {
    }

    public ConnectorSession(byte[] headerBinary, Socket socket) throws Exception {
        if (socket == null || socket.isClosed()) {
            throw new IllegalArgumentException("\u63a5\u7d9a\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.socket = socket;
            this.socket.setSendBufferSize(131072);
            this.socket.setReceiveBufferSize(131072);
            this.socket.setKeepAlive(true);
            this.socket.setTcpNoDelay(true);
            this.socket.setReuseAddress(true);
            this.socket.setSoLinger(true, 5);
            this.socket.setSoTimeout(2500);
            this.inputStream = new BufferedInputStream(this.socket.getInputStream());
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.connectAddress = socket.getInetAddress();
            this.connectPort = socket.getPort();
            this.updateTime = System.currentTimeMillis();
            this.headerBinary = headerBinary;
        }
        catch (Exception e) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.connectAddress != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("## close:" + this.connectAddress.getHostAddress() + "/" + this.connectPort));
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
        this.connectAddress = null;
        this.headerBinary = null;
    }

    public synchronized InetAddress getInetAddress() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.socket.getInetAddress();
    }

    public synchronized int getPort() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.socket.getPort();
    }

    public synchronized InetAddress getLocalAddress() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.socket.getLocalAddress();
    }

    public synchronized int getLocalPort() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.socket.getLocalPort();
    }

    public synchronized void send(byte[] binary) throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (binary == null || binary.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.outputStream.write(this.headerBinary);
        this.outputStream.write(ConvertParam.convertInt(binary.length + this.headerBinary.length + 4));
        this.outputStream.write(binary);
        this.outputStream.flush();
    }

    public synchronized boolean isClosed() {
        boolean ret = false;
        try {
            if (this.socket == null || !this.socket.isBound() || this.socket.isClosed()) {
                this.destroy();
                ret = true;
            }
            ret = this.updateTime != Long.MAX_VALUE && System.currentTimeMillis() >= 30000L + this.updateTime;
        }
        catch (Exception e) {
            this.destroy();
            ret = true;
        }
        return ret;
    }

    protected synchronized boolean isReceive() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        boolean ret = false;
        if (this.inputStream().available() > 0) {
            ret = true;
        }
        return ret;
    }

    protected synchronized void updateTime() {
        this.updateTime = System.currentTimeMillis();
    }

    protected synchronized void executionUpdateTime() {
        this.updateTime = Long.MAX_VALUE;
    }

    protected synchronized boolean isLocalHost() throws Exception {
        if (this.socket != null && !this.socket.isClosed()) {
            return LOCAL_HOST.equals(this.socket.getInetAddress().getHostAddress());
        }
        return false;
    }

    protected synchronized Socket socket() {
        if (this.isClosed()) {
            return null;
        }
        return this.socket;
    }

    protected synchronized InputStream inputStream() {
        if (this.isClosed()) {
            return null;
        }
        return this.inputStream;
    }

    protected synchronized OutputStream outputStream() {
        if (this.isClosed()) {
            return null;
        }
        return this.outputStream;
    }
}

