/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import org.maachang.dbm.engine.M2KeyChild;
import org.maachang.dbm.engine.M2NextKey;
import org.maachang.dbm.engine.M2RawHash;
import org.maachang.dbm.engine.M2Sector;
import org.maachang.dbm.engine.M2SectorData;

public class M2Key {
    private M2RawHash hash = null;
    private M2Sector sector = null;

    private M2Key() {
    }

    public M2Key(M2RawHash hash, M2Sector sector) {
        this.hash = hash;
        this.sector = sector;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.hash != null) {
            this.hash.destroy();
        }
        this.hash = null;
        this.sector = null;
    }

    public void add(int code, byte[] key, int no, int fileNo) throws Exception {
        M2KeyChild ch = new M2KeyChild();
        int code2 = M2Key.secondHash(key);
        if (this.search(ch, code, code2, key)) {
            this.sector.removeAll(ch.getElementPos(), ch.getElementFileNo());
            ch.setElementPos(no);
            ch.setElementFileNo(fileNo);
            M2SectorData data = ch.header(this.sector.getBlockSize());
            this.sector.writeOne(data, ch.getStartPos(), ch.getStartFileNo());
        } else if (ch.getStartPos() == -1) {
            ch.clear();
            ch.setElementPos(no);
            ch.setElementFileNo(fileNo);
            ch.setHashCode(code);
            ch.setHashCode2(code2);
            ch.setData(key);
            byte[] b = ch.save();
            long p = this.sector.writeAll(1255, b, 0, b.length);
            int newChPos = (int)(p & 0xFFFFFFFFL);
            int newChFNo = (int)((p & 0xFFFFFFFF00000000L) >> 32);
            this.hash.put(M2Key.mask(code), newChPos, newChFNo);
            this.hash.addOne();
            ch = null;
        } else {
            M2KeyChild newCh = new M2KeyChild();
            newCh.setBefPos(ch.getStartPos());
            newCh.setBefFileNo(ch.getStartFileNo());
            newCh.setElementPos(no);
            newCh.setElementFileNo(fileNo);
            newCh.setHashCode(code);
            newCh.setHashCode2(code2);
            newCh.setData(key);
            byte[] b = newCh.save();
            long p = this.sector.writeAll(1255, b, 0, b.length);
            int newChPos = (int)(p & 0xFFFFFFFFL);
            int newChFNo = (int)((p & 0xFFFFFFFF00000000L) >> 32);
            ch.setNextPos(newChPos);
            ch.setNextFileNo(newChFNo);
            M2SectorData data = ch.header(this.sector.getBlockSize());
            this.sector.writeOne(data, ch.getStartPos(), ch.getStartFileNo());
            this.hash.addOne();
        }
    }

    public void remove(int code, byte[] key) throws Exception {
        M2KeyChild ch = new M2KeyChild();
        int code2 = M2Key.secondHash(key);
        if (this.search(ch, code, code2, key)) {
            this.sector.removeAll(ch.getElementPos(), ch.getElementFileNo());
            this.sector.removeAll(ch.getStartPos(), ch.getStartFileNo());
            this.hash.deleteOne();
            int befPos = ch.getBefPos();
            int befFileNo = ch.getBefFileNo();
            int nextPos = ch.getNextPos();
            int nextFileNo = ch.getNextFileNo();
            if (nextPos <= -1 || nextFileNo <= -1) {
                nextPos = -1;
                nextFileNo = -1;
            }
            if (befPos <= -1 || befFileNo <= -1) {
                befPos = -1;
                befFileNo = -1;
            }
            if (nextPos <= -1 && nextFileNo <= -1 && befPos <= -1 && befFileNo <= -1) {
                this.hash.remove(M2Key.mask(code));
            } else {
                M2SectorData data;
                if (befPos >= 0 && befFileNo >= 0) {
                    data = new M2SectorData();
                    this.sector.readOne(data, befPos, befFileNo);
                    ch.create(data, befPos, befFileNo);
                    ch.setNextPos(nextPos);
                    ch.setNextFileNo(nextFileNo);
                    ch.header(this.sector.getBlockSize(), data);
                    this.sector.writeOne(data, befPos, befFileNo);
                }
                if (nextPos >= 0 && nextFileNo >= 0) {
                    data = new M2SectorData();
                    this.sector.readOne(data, nextPos, nextFileNo);
                    ch.create(data, nextPos, nextPos);
                    ch.setBefPos(befPos);
                    ch.setBefFileNo(befFileNo);
                    ch.header(this.sector.getBlockSize(), data);
                    this.sector.writeOne(data, nextPos, nextFileNo);
                    if (befPos <= -1 || befFileNo <= -1) {
                        this.hash.put(M2Key.mask(code), nextPos, nextFileNo);
                    }
                }
            }
        }
    }

    public long get(int code, byte[] key) throws Exception {
        M2KeyChild ch = new M2KeyChild();
        int code2 = M2Key.secondHash(key);
        if (this.search(ch, code, code2, key)) {
            return (long)ch.getElementPos() & 0xFFFFFFFFL | ((long)ch.getElementFileNo() & 0xFFFFFFFFL) << 32;
        }
        return -1L;
    }

    public M2NextKey nextKey(M2NextKey next) throws Exception {
        if (next == null) {
            next = new M2NextKey();
        }
        if (next.getCount() >= this.hash.getSize()) {
            return null;
        }
        boolean result = false;
        int pos = -1;
        int fno = -1;
        while (true) {
            if (next.getPos() <= -1 && next.getFileNo() <= 0) {
                int code = this.hash.useHash(next.getHashNo());
                if (code <= -1) {
                    return null;
                }
                next.setHashNo(code);
                long pf = this.hash.get(code);
                if (pf <= -1L) continue;
                pos = (int)(pf & 0xFFFFFFFFL);
                fno = (int)((pf & 0xFFFFFFFF00000000L) >> 32);
                result = true;
            } else {
                pos = next.getPos();
                fno = next.getFileNo();
                result = true;
            }
            if (result) break;
        }
        byte[] b = this.sector.readAll(pos, fno);
        M2KeyChild ch = new M2KeyChild(b, pos, fno, -1, -1);
        next.setPos(ch.getNextPos());
        next.setFileNo(ch.getNextFileNo());
        next.setKey(ch.getData());
        next.addCount();
        return next;
    }

    public int size() throws Exception {
        return this.hash.getSize();
    }

    public M2RawHash getHash() {
        return this.hash;
    }

    private boolean search(M2KeyChild ch, int code, int code2, byte[] key) throws Exception {
        while (true) {
            try {
                ch.clear();
                int hcd = M2Key.mask(code);
                long startPos = this.hash.get(hcd);
                if (startPos <= -1L) {
                    return false;
                }
                int pos = (int)(startPos & 0xFFFFFFFFL);
                int fno = (int)((startPos & 0xFFFFFFFF00000000L) >> 32);
                M2SectorData data = new M2SectorData();
                while (true) {
                    if (pos <= -1 || fno <= -1) {
                        return false;
                    }
                    this.sector.readOne(data, pos, fno);
                    if (data.getLength() <= -1) {
                        return false;
                    }
                    if (this.useChild(ch, data, pos, fno, hcd, code, code2, key)) {
                        return true;
                    }
                    pos = ch.getNextPos();
                    fno = ch.getNextFileNo();
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private boolean useChild(M2KeyChild ch, M2SectorData data, int pos, int fno, int hcd, int code, int code2, byte[] key) throws Exception {
        ch.create(data, pos, fno);
        if (hcd != M2Key.mask(ch.getHashCode())) {
            throw new IOException("\u4e0d\u6b63\u306aHash\u5024\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
        }
        if (ch.getHashCode() != code || ch.getHashCode2() != code2 || ch.getLength() != key.length) {
            return false;
        }
        while (data.getNextNo() > -1 && data.getNextFileNo() > -1) {
            this.sector.readOne(data, data.getNextNo(), data.getNextFileNo());
            ch.addData(data);
        }
        int len = key.length;
        byte[] b = ch.getData();
        int i = 0;
        while (i < len) {
            if (key[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final int mask(int code) {
        return code & M2RawHash.MASK_HASH;
    }

    private static final int secondHash(byte[] key) {
        int len = key.length;
        long c = 2557914061L;
        int i = len - 1;
        while (i >= 0) {
            c = (c << 5) + (c << 2) + c + (long)key[i];
            --i;
        }
        return (int)(c & 0xFFFFFFFFL);
    }
}

