/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import org.maachang.dbm.engine.M2SectorData;
import org.maachang.util.ConvertParam;

class M2KeyChild {
    private static final int MAX_KEY_LENGTH = 0x1000000;
    private static final int HEADER = 36;
    private int startPos = -1;
    private int startFileNo = -1;
    private int sectorNextPos = -1;
    private int sectorNextFileNo = -1;
    private int befPos = -1;
    private int befFileNo = -1;
    private int nextPos = -1;
    private int nextFileNo = -1;
    private int hashCode = -1;
    private int hashCode2 = -1;
    private int elementPos = -1;
    private int elementFileNo = -1;
    private int length = -1;
    private byte[] data = null;
    private int position = 0;

    public M2KeyChild() {
    }

    public M2KeyChild(M2SectorData data, int pos, int fno) throws Exception {
        this.create(data, pos, fno);
    }

    public M2KeyChild(byte[] b, int pos, int fno, int sectorNextNo, int sectorNextFno) throws Exception {
        this.create(b, pos, fno, sectorNextNo, sectorNextFno);
    }

    public void create(M2SectorData data, int pos, int fno) throws Exception {
        this.clear();
        this.startPos = pos;
        this.startFileNo = fno;
        this.sectorNextPos = data.getNextNo();
        this.sectorNextFileNo = data.getNextFileNo();
        byte[] b = data.getData();
        this.befPos = ConvertParam.convertInt((int)0, (byte[])b);
        this.befFileNo = ConvertParam.convertInt((int)4, (byte[])b);
        this.nextPos = ConvertParam.convertInt((int)8, (byte[])b);
        this.nextFileNo = ConvertParam.convertInt((int)12, (byte[])b);
        this.hashCode = ConvertParam.convertInt((int)16, (byte[])b);
        this.hashCode2 = ConvertParam.convertInt((int)20, (byte[])b);
        this.elementPos = ConvertParam.convertInt((int)24, (byte[])b);
        this.elementFileNo = ConvertParam.convertInt((int)28, (byte[])b);
        this.length = ConvertParam.convertInt((int)32, (byte[])b);
        if (this.length > 0x1000000) {
            throw new IOException("\u4e0d\u6b63\u306a\u30c7\u30fc\u30bf\u9577[" + this.length + "]\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
        }
        this.data = new byte[this.length];
        this.position = data.getLength() - 36;
        System.arraycopy(b, 36, this.data, 0, this.position);
    }

    public void create(byte[] b, int pos, int fno, int sectorNextNo, int sectorNextFno) throws Exception {
        this.clear();
        this.startPos = pos;
        this.startFileNo = fno;
        this.sectorNextPos = sectorNextNo;
        this.sectorNextFileNo = sectorNextFno;
        this.befPos = ConvertParam.convertInt((int)0, (byte[])b);
        this.befFileNo = ConvertParam.convertInt((int)4, (byte[])b);
        this.nextPos = ConvertParam.convertInt((int)8, (byte[])b);
        this.nextFileNo = ConvertParam.convertInt((int)12, (byte[])b);
        this.hashCode = ConvertParam.convertInt((int)16, (byte[])b);
        this.hashCode2 = ConvertParam.convertInt((int)20, (byte[])b);
        this.elementPos = ConvertParam.convertInt((int)24, (byte[])b);
        this.elementFileNo = ConvertParam.convertInt((int)28, (byte[])b);
        this.length = ConvertParam.convertInt((int)32, (byte[])b);
        if (this.length > 0x1000000) {
            throw new IOException("\u4e0d\u6b63\u306a\u30c7\u30fc\u30bf\u9577[" + this.length + "]\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
        }
        this.data = new byte[this.length];
        System.arraycopy(b, 36, this.data, 0, this.length);
        this.position = this.length;
    }

    public void clear() {
        this.startPos = -1;
        this.startFileNo = -1;
        this.sectorNextPos = -1;
        this.sectorNextFileNo = -1;
        this.befPos = -1;
        this.befFileNo = -1;
        this.nextPos = -1;
        this.nextFileNo = -1;
        this.hashCode = -1;
        this.hashCode2 = -1;
        this.elementPos = -1;
        this.elementFileNo = -1;
        this.length = -1;
        this.data = null;
        this.position = 0;
    }

    public void addData(M2SectorData data) {
        int len = data.getLength();
        System.arraycopy(data.getData(), 0, this.data, this.position, len);
        this.position += len;
    }

    public void setStartPos(int startPos) {
        this.startPos = startPos;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setStartFileNo(int startFileNo) {
        this.startFileNo = startFileNo;
    }

    public int getStartFileNo() {
        return this.startFileNo;
    }

    public void setSectorNextPos(int sectorNextPos) {
        this.sectorNextPos = sectorNextPos;
    }

    public int getSectorNextPos() {
        return this.sectorNextPos;
    }

    public void setSectorNextFileNo(int sectorNextFileNo) {
        this.sectorNextFileNo = sectorNextFileNo;
    }

    public int getSectorNextFileNo() {
        return this.sectorNextFileNo;
    }

    public void setBefPos(int befPos) {
        this.befPos = befPos;
    }

    public int getBefPos() {
        return this.befPos;
    }

    public void setBefFileNo(int befFileNo) {
        this.befFileNo = befFileNo;
    }

    public int getBefFileNo() {
        return this.befFileNo;
    }

    public void setNextPos(int nextPos) {
        this.nextPos = nextPos;
    }

    public int getNextPos() {
        return this.nextPos;
    }

    public void setNextFileNo(int nextFileNo) {
        this.nextFileNo = nextFileNo;
    }

    public int getNextFileNo() {
        return this.nextFileNo;
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public void setHashCode2(int hashCode2) {
        this.hashCode2 = hashCode2;
    }

    public int getHashCode2() {
        return this.hashCode2;
    }

    public void setElementPos(int elementPos) {
        this.elementPos = elementPos;
    }

    public int getElementPos() {
        return this.elementPos;
    }

    public void setElementFileNo(int elementFileNo) {
        this.elementFileNo = elementFileNo;
    }

    public int getElementFileNo() {
        return this.elementFileNo;
    }

    public int getLength() {
        return this.length;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.length = data.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] save() {
        byte[] ret = new byte[36 + this.length];
        int p = 0;
        ConvertParam.convertInt((byte[])ret, (int)p, (int)this.befPos);
        ConvertParam.convertInt((byte[])ret, (int)(p += 4), (int)this.befFileNo);
        ConvertParam.convertInt((byte[])ret, (int)(p += 4), (int)this.nextPos);
        ConvertParam.convertInt((byte[])ret, (int)(p += 4), (int)this.nextFileNo);
        ConvertParam.convertInt((byte[])ret, (int)(p += 4), (int)this.hashCode);
        ConvertParam.convertInt((byte[])ret, (int)(p += 4), (int)this.hashCode2);
        ConvertParam.convertInt((byte[])ret, (int)(p += 4), (int)this.elementPos);
        ConvertParam.convertInt((byte[])ret, (int)(p += 4), (int)this.elementFileNo);
        ConvertParam.convertInt((byte[])ret, (int)(p += 4), (int)this.length);
        System.arraycopy(this.data, 0, ret, p += 4, this.length);
        return ret;
    }

    public M2SectorData header(int blockSize) {
        M2SectorData ret = new M2SectorData();
        this.header(blockSize, ret);
        return ret;
    }

    public void header(int blockSize, M2SectorData data) {
        data.setSectorType(1255);
        int len = this.length >= blockSize ? blockSize : this.length;
        byte[] b = new byte[len + 36];
        int p = 0;
        ConvertParam.convertInt((byte[])b, (int)p, (int)this.befPos);
        ConvertParam.convertInt((byte[])b, (int)(p += 4), (int)this.befFileNo);
        ConvertParam.convertInt((byte[])b, (int)(p += 4), (int)this.nextPos);
        ConvertParam.convertInt((byte[])b, (int)(p += 4), (int)this.nextFileNo);
        ConvertParam.convertInt((byte[])b, (int)(p += 4), (int)this.hashCode);
        ConvertParam.convertInt((byte[])b, (int)(p += 4), (int)this.hashCode2);
        ConvertParam.convertInt((byte[])b, (int)(p += 4), (int)this.elementPos);
        ConvertParam.convertInt((byte[])b, (int)(p += 4), (int)this.elementFileNo);
        ConvertParam.convertInt((byte[])b, (int)(p += 4), (int)this.length);
        p += 4;
        System.arraycopy(this.data, 0, b, 36, len);
        data.setData(b);
        data.setLength(b.length);
        data.setNextNo(this.sectorNextPos);
        data.setNextFileNo(this.sectorNextFileNo);
    }

    public String toString() {
        return " startPos:" + this.startPos + " startFileNo:" + this.startFileNo + " sectorNextPos:" + this.sectorNextPos + " sectorNextFileNo:" + this.sectorNextFileNo + " befPos:" + this.befPos + " befFileNo:" + this.befFileNo + " nextPos:" + this.nextPos + " nextFileNo:" + this.nextFileNo + " hashCode:" + this.hashCode + " hashCode2:" + this.hashCode2 + " elementPos:" + this.elementPos + " elementFileNo:" + this.elementFileNo + " length:" + this.length;
    }
}

