/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.comet.httpd.engine.auth.HttpdAuthUsers;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;

public class AuthUsersByConfig
implements HttpdAuthUsers {
    private static final String BASE_SECTION = "auth-users";
    private static final String CHARSET = "UTF8";
    private static final String READ_FILE = "conf/users.conf";
    private Config iniParams = null;
    private String fileName = null;
    private long lastUpdate = -1L;

    public synchronized void open() throws Exception {
        this.open(READ_FILE);
    }

    public synchronized void open(String name) throws Exception {
        this.fileName = FileUtil.getFullPath((String)name);
        try {
            this.reload();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public synchronized void close() {
        this.iniParams = null;
        this.fileName = null;
        this.lastUpdate = -1L;
    }

    public String[] getPassword(String user) throws Exception {
        if (user == null || (user = user.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30e6\u30fc\u30b6\u540d\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.updateByReload();
        String[] ret = this.iniParams.getAll(BASE_SECTION, user);
        if (ret == null) {
            return null;
        }
        int len = ret.length;
        int i = 0;
        while (i < len) {
            if (ret[i] == null) {
                ret[i] = "";
            }
            ++i;
        }
        return ret;
    }

    public boolean isUser(String user) throws Exception {
        if (user == null || (user = user.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30e6\u30fc\u30b6\u540d\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.updateByReload();
        return this.iniParams.size(BASE_SECTION, user) > 0;
    }

    private final void reload() throws Exception {
        BufferedReader buf = null;
        if (FileUtil.isFileExists((String)this.fileName)) {
            try {
                buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), CHARSET));
                Config iniParams = new Config();
                ReadIni.analisys((Config)iniParams, (BufferedReader)buf);
                buf.close();
                buf = null;
                long last = FileUtil.getLastTime((String)this.fileName);
                this.iniParams = iniParams;
                this.lastUpdate = last;
            }
            finally {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void updateByReload() {
        try {
            long tm = FileUtil.getLastTime((String)this.fileName);
            if (this.lastUpdate != tm) {
                this.reload();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

