/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd;

import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.comet.httpd.HttpdBinary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpdParams {
    private HashMap<String, Object> params = new HashMap();

    protected void finalize() throws Exception {
        this.params = null;
    }

    public void add(HttpdParams param) {
        if (param == null || param.size() <= 0) {
            return;
        }
        String[] keys = param.getKeys();
        if (keys != null) {
            int len = keys.length;
            int i = 0;
            while (i < len) {
                int lenJ = param.size(keys[i]);
                int j = 0;
                while (j < lenJ) {
                    this.addParam(keys[i], param.getParam(keys[i], j));
                    ++j;
                }
                ++i;
            }
        }
    }

    public void addParam(String key, Object value) {
        this.pushParam(false, key, value);
    }

    public void setParam(String key, Object value) {
        this.pushParam(true, key, value);
    }

    private void pushParam(boolean mode, String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            value = "";
        } else if (!(value instanceof String) && !(value instanceof HttpdBinary)) {
            return;
        }
        if (mode) {
            this.params.put(key, value);
        } else if (!this.params.containsKey(key)) {
            this.params.put(key, value);
        } else {
            ArrayList<Object> lst = null;
            Object v = this.params.get(key);
            if (v instanceof ArrayList) {
                lst = (ArrayList<Object>)v;
            } else {
                lst = new ArrayList<Object>();
                lst.add(v);
                this.params.put(key, lst);
            }
            lst.add(value);
        }
    }

    public void removeParam(String key) {
        if (key == null || this.params == null) {
            return;
        }
        this.params.remove(key);
    }

    public void removeParam(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return;
        }
        int len = this.getKeyByLength(key);
        if (len <= 0 || no >= len) {
            return;
        }
        if (len == 1) {
            this.params.remove(key);
        } else {
            ArrayList v = (ArrayList)this.params.get(key);
            v.remove(no);
        }
    }

    public String getParam(String key) {
        return this.getParam(key, 0);
    }

    public String getParam(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return null;
        }
        int len = this.getKeyByLength(key);
        if (len <= 0 || no >= len) {
            return null;
        }
        Object v = this.params.get(key);
        if (v instanceof ArrayList) {
            v = ((ArrayList)v).get(no);
        }
        if (v instanceof String) {
            return (String)v;
        }
        return v.toString();
    }

    public HttpdBinary getParamByBinary(String key) {
        return this.getParamByBinary(key, 0);
    }

    public HttpdBinary getParamByBinary(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return null;
        }
        int len = this.getKeyByLength(key);
        if (len <= 0 || no >= len) {
            return null;
        }
        Object v = this.params.get(key);
        if (v instanceof ArrayList) {
            v = ((ArrayList)v).get(no);
        }
        if (v instanceof String) {
            HttpdBinary b = null;
            try {
                b = new HttpdBinary(key, "text/plain", ((String)v).getBytes("UTF8"));
            }
            catch (Exception e) {
                b = null;
            }
            return b;
        }
        return (HttpdBinary)v;
    }

    public boolean getParamType(String key) {
        return this.getParamType(key, 0);
    }

    public boolean getParamType(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return false;
        }
        int len = this.getKeyByLength(key);
        if (len <= 0 || no >= len) {
            return false;
        }
        Object v = this.params.get(key);
        if (v instanceof ArrayList) {
            v = ((ArrayList)v).get(no);
        }
        return !(v instanceof String);
    }

    public int size() {
        return this.params == null ? 0 : this.params.size();
    }

    public int size(String key) {
        if (key == null || this.params == null) {
            return 0;
        }
        return this.getKeyByLength(key);
    }

    public String[] getKeys() {
        if (this.params == null || this.params.size() <= 0) {
            return null;
        }
        Object[] keys = this.params.keySet().toArray();
        if (keys != null) {
            int len = keys.length;
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)keys[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public boolean isKey(String key) {
        if (this.params == null) {
            return false;
        }
        return this.params.containsKey(key);
    }

    public HashMap<String, Object> getPrivateMap() {
        return this.params;
    }

    public String toString() {
        String[] keys = this.getKeys();
        if (keys != null) {
            StringBuilder buf = new StringBuilder();
            int len = keys.length;
            int i = 0;
            while (i < len) {
                Object v;
                if (i != 0) {
                    buf.append(",");
                }
                if ((v = this.params.get(keys[i])) instanceof ArrayList) {
                    ArrayList lst = (ArrayList)v;
                    if (lst != null) {
                        int lenJ = lst.size();
                        int j = 0;
                        while (j < lenJ) {
                            if (j != 0) {
                                buf.append(",");
                            }
                            Object objs = lst.get(j);
                            buf.append(" [").append(keys[i]).append(":");
                            if (objs instanceof String) {
                                buf.append(objs).append("]");
                            } else if (objs instanceof HttpdBinary) {
                                buf.append(" orginal/").append(((HttpdBinary)objs).getOriginalName()).append(" length/").append(((HttpdBinary)objs).getLength()).append("]");
                            }
                            ++j;
                        }
                    }
                } else {
                    buf.append(" [").append(keys[i]).append(":");
                    if (v instanceof String) {
                        buf.append(v).append("]");
                    } else if (v instanceof HttpdBinary) {
                        buf.append(" orginal/").append(((HttpdBinary)v).getOriginalName()).append(" length/").append(((HttpdBinary)v).getLength()).append("]");
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        return "null";
    }

    private int getKeyByLength(String key) {
        if (key == null || key.length() <= 0) {
            return 0;
        }
        if (!this.params.containsKey(key)) {
            return 0;
        }
        Object v = this.params.get(key);
        if (v instanceof ArrayList) {
            return ((ArrayList)v).size();
        }
        return 1;
    }
}

