/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.comet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.HttpdResponseInstance;
import org.maachang.comet.httpd.engine.comet.ConnectComet;
import org.maachang.comet.httpd.engine.script.BaseModel;
import org.maachang.comet.httpd.engine.script.BaseModelImpl;
import org.maachang.comet.httpd.engine.script.EndScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.WebAppScriptFactory;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.conf.ConvIniParam;
import org.maachang.manager.GlobalManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comet {
    private static final Log LOG = LogFactory.getLog(Comet.class);
    private static final String COMET_TIMEOUT_PARAM = "CometTimeout";
    private String groupId = null;
    private String scriptPath = null;
    private List<ConnectComet> connects = null;
    private long createTime = -1L;
    private long updateTime = -1L;
    private final Object sync = new Object();

    private Comet() {
    }

    public Comet(String groupId, String scriptPath) throws Exception {
        if (groupId == null || (groupId = groupId.trim()).length() <= 0 || scriptPath == null || (scriptPath = scriptPath.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.groupId = groupId;
        this.scriptPath = scriptPath;
        this.createTime = System.currentTimeMillis();
        this.updateTime = System.currentTimeMillis();
        this.connects = Collections.synchronizedList(new ArrayList());
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void clear() {
        Comet.destroyConnection(this.connects);
        this.groupId = null;
        this.scriptPath = null;
        this.createTime = -1L;
        this.updateTime = -1L;
        this.connects = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConnection(HttpdRequest request) throws Exception {
        if (request == null || !request.isUse()) {
            return;
        }
        if (this.connects == null) {
            return;
        }
        ConnectComet conn = new ConnectComet(request);
        this.connects.add(conn);
        Object object = this.sync;
        synchronized (object) {
            this.updateTime = System.currentTimeMillis();
        }
    }

    protected void cleanConnection() {
        if (this.connects == null) {
            return;
        }
        int len = this.connects.size();
        int i = len - 1;
        while (i >= 0) {
            try {
                String timeout;
                ConnectComet conn = this.connects.get(i);
                if (conn == null || !conn.isConnection()) {
                    if (conn != null) {
                        conn.destroy();
                    }
                    this.connects.remove(i);
                }
                if ((timeout = conn.getRequest().getQuery().getParam(COMET_TIMEOUT_PARAM)) != null) {
                    long tm = ConvIniParam.getLong((String)timeout);
                    timeout = null;
                    if (tm > 0L && conn.getConnectionTime() + tm <= System.currentTimeMillis()) {
                        conn.destroy();
                        this.connects.remove(i);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            --i;
        }
    }

    public void send(Object args, String groupId) throws Exception {
        List<ConnectComet> conns = this.getCometConnects();
        if (conns == null || conns.size() <= 0) {
            return;
        }
        this.sendAll(conns, this.scriptPath, args, groupId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... exit - comet:" + groupId));
        }
    }

    public ArrayList<String> getConnectSessionIds() {
        if (this.connects == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        int len = this.connects.size();
        int i = len - 1;
        while (i >= 0) {
            try {
                ConnectComet conn = this.connects.get(i);
                if (conn != null && conn.isConnection()) {
                    HttpdSession session = conn.getRequest().getSession();
                    if (session != null && session.getSessionId() != null) {
                        ret.add(session.getSessionId());
                    }
                } else {
                    if (conn != null) {
                        conn.destroy();
                    }
                    this.connects.remove(i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            --i;
        }
        if (ret.size() <= 0) {
            return null;
        }
        return ret;
    }

    public int getConnectSize() {
        if (this.connects != null) {
            return this.connects.size();
        }
        return 0;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUpdateTime() {
        long ret = -1L;
        Object object = this.sync;
        synchronized (object) {
            ret = this.updateTime;
        }
        return ret;
    }

    public static final Object oneSend(HttpdResponse res, BaseModel baseModel, HttpdRequest request, String scriptPath, String groupId) throws Exception {
        return Comet.oneSend(res, baseModel, request, scriptPath, null, groupId);
    }

    public static final Object oneSend(HttpdResponse res, BaseModel baseModel, HttpdRequest request, String scriptPath, Object args, String groupId) throws Exception {
        Object ret;
        block24: {
            WebAppScriptFactory webapp = (WebAppScriptFactory)GlobalManager.getValue((String)"WEBAPP_FACTORY");
            if (webapp == null) {
                throw new IOException("WebAppScriptFactory\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            Script comet = webapp.getApplication(scriptPath);
            if (comet == null) {
                throw new IOException("[" + scriptPath + "]\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            ret = null;
            boolean libFlag = false;
            SimpleScriptContext ctx = null;
            boolean errorFlag = false;
            try {
                try {
                    ctx = new SimpleScriptContext();
                    CacheScriptManager.getInstance().script(ctx);
                    libFlag = true;
                    ScriptDef.setDirectoryByBindings(ctx);
                    Bindings bindings = ctx.getBindings(100);
                    bindings.put("_$script$query", (Object)ScriptDef.getQuery(request.getQuery()));
                    bindings.put("__$type$script", (Object)"comet");
                    bindings.put("_$script$base_model", (Object)baseModel);
                    bindings.put("_$script$path", (Object)scriptPath);
                    bindings.put("_$script$header", (Object)request.getHeader());
                    bindings.put("_$script$comet_args", args);
                    bindings.put("_$script$group_id", (Object)groupId);
                    HttpdSession session = request.getSession();
                    if (session != null) {
                        bindings.put("_$script$session", (Object)session);
                    }
                    if (res != null) {
                        res.setHttpCache(true);
                        res.setHttpClose(false);
                        res.setCookieSession(request);
                        res.getHeader().setHeader("Content-Type", "text/xml; charset=utf-8");
                        res.setHttpCache(true);
                        bindings.put("_$script$request", (Object)request);
                        bindings.put("_$script$response", (Object)res);
                    }
                    comet.getScript().execution(ctx, null);
                    if (res != null) {
                        res.flush();
                    }
                }
                catch (ScriptException sc) {
                    if (ctx != null && EndScript.isEndScript(sc)) {
                        ret = EndScript.getEndByResult(ctx);
                        break block24;
                    }
                    errorFlag = true;
                    throw sc;
                }
                catch (Exception e) {
                    errorFlag = true;
                    throw e;
                }
            }
            finally {
                if (baseModel.isCreate()) {
                    try {
                        if (errorFlag) {
                            baseModel.rollback();
                        } else {
                            baseModel.commit();
                        }
                    }
                    catch (Exception exception) {}
                }
                if (libFlag) {
                    try {
                        CacheScriptManager.getInstance().executionByExitRequest();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConnectComet> getCometConnects() {
        if (this.connects != null) {
            List<ConnectComet> ret = this.connects;
            this.connects = Collections.synchronizedList(new ArrayList());
            Object object = this.sync;
            synchronized (object) {
                this.updateTime = System.currentTimeMillis();
            }
            return ret;
        }
        return null;
    }

    private void sendAll(List<ConnectComet> conns, String scriptPath, Object args, String groupId) throws Exception {
        BaseModelImpl baseModel = new BaseModelImpl();
        int len = conns.size();
        int i = 0;
        while (i < len) {
            ConnectComet conn = conns.remove(0);
            if (conn == null || !conn.isConnection()) {
                if (conn != null) {
                    conn.destroy();
                }
            } else {
                try {
                    HttpdResponse res = HttpdResponseInstance.createResponse(conn.getRequest(), conn.getRequest().getUrlPath(), 200, conn.getRequest().getKeepAliveTimeout(), conn.getRequest().getKeepAliveCount());
                    Comet.oneSend(res, baseModel, conn.getRequest(), scriptPath, args, groupId);
                    res.flush();
                    res.destroy();
                    ConnectionInfo info = conn.getConnectionInfo();
                    try {
                        if (info != null && info.isUse()) {
                            if (info.isCloseFlag()) {
                                info.destroy();
                            } else if (info.getCount() > 0 && info.recyclingConnection()) {
                                conn.cancel();
                            }
                        } else if (info != null) {
                            info.destroy();
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    conn.destroy();
                }
                catch (Exception e) {
                    if (conn != null) {
                        conn.destroy();
                    }
                    LOG.error((Object)"comet-error", (Throwable)e);
                }
            }
            ++i;
        }
    }

    private static final void destroyConnection(List<ConnectComet> conns) {
        if (conns != null) {
            int len = conns.size();
            int i = 0;
            while (i < len) {
                ConnectComet con = conns.get(i);
                if (con != null) {
                    con.destroy();
                }
                ++i;
            }
            conns.clear();
        }
    }
}

