/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.comet;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.comet.Comet;
import org.maachang.comet.httpd.engine.comet.CometParamPlus;
import org.maachang.comet.httpd.engine.comet.ExecutionPoolComet;

class ExecutionOnePoolComet
extends Thread {
    private static final Log LOG = LogFactory.getLog(ExecutionPoolComet.class);
    private static final long IDLE_TIME = 30L;
    private ArrayList<CometParamPlus> queue = null;
    private volatile boolean stopFlag = false;
    private volatile boolean executionComet = false;
    private Object sync = new Object();

    public ExecutionOnePoolComet() {
        this.queue = new ArrayList();
        this.setDaemon(true);
        this.start();
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void clear() {
        this.stopThread();
        this.clearQueue();
    }

    public synchronized boolean executionComet(Comet comet, Object args, String groupId) {
        if (this.isExecutionMode()) {
            return false;
        }
        CometParamPlus cometParam = new CometParamPlus();
        cometParam.comet = comet;
        cometParam.args = args;
        cometParam.groupId = groupId;
        this.queue.add(cometParam);
        this.executionMode();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopThread() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.stopFlag;
        }
        return ret;
    }

    public boolean isExecution() {
        return this.isExecutionMode();
    }

    public void run() {
        block12: {
            block8: while (true) {
                while (true) {
                    if (this.isStopThread()) {
                        break block12;
                    }
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        CometParamPlus cometParam = this.get();
                        if (cometParam == null) continue block8;
                        Comet comet = cometParam.comet;
                        String groupId = cometParam.groupId;
                        Object args = cometParam.args;
                        if (comet != null && comet.getConnectSize() > 0) {
                            comet.send(args, groupId);
                        }
                        this.endExecutionMode();
                        continue block8;
                    }
                    catch (OutOfMemoryError mm) {
                        LOG.error((Object)"OutOfMemoryError", (Throwable)mm);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            finally {
                LOG.warn((Object)("## stopThread:" + this.getClass().getName()));
            }
        }
    }

    private synchronized CometParamPlus get() {
        if (this.queue != null && this.queue.size() > 0) {
            return this.queue.remove(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThread() {
        Object object = this.sync;
        synchronized (object) {
            this.stopFlag = true;
        }
    }

    private synchronized void clearQueue() {
        this.queue.clear();
    }

    private synchronized void executionMode() {
        this.executionComet = true;
    }

    private synchronized void endExecutionMode() {
        this.executionComet = false;
    }

    private synchronized boolean isExecutionMode() {
        return this.executionComet;
    }
}

