/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.errors;

import org.maachang.comet.httpd.HttpdErrorDef;
import org.maachang.comet.httpd.engine.errors.HttpdErrorPageTemplate;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

public class HttpdErrorPageManager {
    private static final String DEFAULT_TEMPLATE = "org/maachang/comet/httpd/engine/errors/default.error";
    private static final String ERROR_PAGE = "error.html";
    private String errorPageDirectory = null;
    private String defaultTemplate = null;

    private HttpdErrorPageManager() {
    }

    public HttpdErrorPageManager(String directory) throws Exception {
        if (directory == null || (directory = directory.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!(directory = StringUtil.changeString((String)directory, (String)"\\", (String)"/")).startsWith("/")) {
            directory = "/" + directory;
        }
        if (!directory.endsWith("/")) {
            directory = String.valueOf(directory) + "/";
        }
        this.errorPageDirectory = String.valueOf(directory) + "error/";
        this.defaultTemplate = FileUtil.getScriptByResource((String)DEFAULT_TEMPLATE, null);
    }

    protected void finalize() throws Exception {
        this.errorPageDirectory = null;
        this.defaultTemplate = null;
    }

    public String getErrorPage(String url, int code, String message, String detail) throws Exception {
        int p;
        String path;
        if (url == null || url.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (message == null || message.length() <= 0) {
            message = HttpdErrorDef.convertErrorMessage(code);
        }
        if (!(path = url.substring(1, url.length())).endsWith("/") && (p = path.lastIndexOf("/")) != -1) {
            path = path.substring(0, p + 1);
        }
        String template = this.defaultTemplate;
        String useErrorPage = this.getErrorTemplate(code, url);
        if (useErrorPage != null) {
            template = useErrorPage;
        }
        useErrorPage = null;
        return HttpdErrorPageTemplate.createErrorPage(template, String.valueOf(code), message, detail, url);
    }

    public String getDefaultErrorPage(String url, int code, String message, String detail) {
        try {
            return HttpdErrorPageTemplate.createErrorPage(this.defaultTemplate, String.valueOf(code), message, detail, url);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getErrorTemplate(int state, String url) throws Exception {
        String path = url;
        int p = path.indexOf("/");
        path = p >= 0 ? path.substring(p + 1) : "";
        String codePage = state + ".html";
        String errorPage = ERROR_PAGE + ".html";
        while (true) {
            String target;
            if (!(target = this.errorPageDirectory + path).endsWith("/")) {
                target = String.valueOf(target) + "/";
            }
            if (FileUtil.isFileExists((String)(String.valueOf(target) + codePage))) {
                return FileUtil.getFileByString((String)(String.valueOf(target) + codePage), (String)"UTF8");
            }
            if (FileUtil.isFileExists((String)(String.valueOf(target) + ERROR_PAGE))) {
                return FileUtil.getFileByString((String)(String.valueOf(target) + errorPage), (String)"UTF8");
            }
            if (path.length() <= 0) {
                return null;
            }
            p = path.lastIndexOf("/");
            if (p != -1) {
                if ((p = (path = path.substring(0, p)).lastIndexOf("/")) != -1) {
                    path = path.substring(0, p);
                    continue;
                }
                path = "";
                continue;
            }
            path = "";
        }
    }
}

