/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import org.maachang.comet.httpd.engine.script.BaseModel;
import org.maachang.comet.httpd.engine.script.dao.Dao;
import org.maachang.comet.httpd.engine.script.dao.DaoFactory;
import org.maachang.comet.httpd.engine.script.dao.MasterCache;
import org.maachang.comet.httpd.engine.script.dao.MetaJson;
import org.maachang.comet.httpd.engine.script.image.ImageManager;
import org.maachang.comet.httpd.engine.script.image.ImageOp;
import org.maachang.comet.mdbm.SingleMDbm;
import org.maachang.dao.ExecutionDao;
import org.maachang.dao.MaachangDaoException;
import org.maachang.dao.dbms.Record;
import org.maachang.dbm.MDbm;
import org.maachang.manager.GlobalManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseModelImpl
implements BaseModel {
    private Record record = null;
    private ScriptContext context = null;
    private MDbm mdbm = null;
    private ImageOp imageOp = null;
    private ArrayList<String> updateTables = null;
    private boolean createFlag = false;

    protected void finalize() throws Exception {
        this.clear();
    }

    @Override
    public synchronized void create(boolean mode, ScriptContext context, Record record) throws Exception {
        if (record == null) {
            throw new IOException("Record\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.record = record;
        this.context = context;
        if (!SingleMDbm.getInstance().isCreate()) {
            if (mode) {
                SingleMDbm.getInstance().createMDbm(false);
            } else {
                SingleMDbm.getInstance().createMDbm(true);
            }
        }
        this.mdbm = SingleMDbm.getInstance().getMDbm(!record.getConnection().getAutoCommit());
        this.imageOp = ImageManager.getImageOp(this.mdbm);
        this.updateTables = null;
        this.createFlag = true;
    }

    @Override
    public void clear() {
        if (this.mdbm != null) {
            try {
                this.mdbm.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.record != null) {
            try {
                this.record.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.record.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.updateTables != null) {
            this.updateTables.clear();
        }
        this.record = null;
        this.context = null;
        this.imageOp = null;
        this.mdbm = null;
        this.updateTables = null;
        this.createFlag = false;
    }

    @Override
    public void commit() throws Exception {
        if (this.createFlag) {
            this.checkCommit();
            if (this.mdbm != null) {
                this.mdbm.commit();
            }
            this.record.commit();
            if (this.updateTables != null && this.updateTables.size() >= 0) {
                MasterCache cache = (MasterCache)GlobalManager.getInstance().get("MASTER_DB_CACHE_MANAGER");
                if (cache != null) {
                    int len = this.updateTables.size();
                    int i = 0;
                    while (i < len) {
                        cache.clearCache(this.updateTables.get(i));
                        ++i;
                    }
                }
                this.updateTables.clear();
                this.updateTables = null;
            }
        }
    }

    @Override
    public void rollback() throws Exception {
        if (this.createFlag) {
            if (this.mdbm != null) {
                try {
                    this.mdbm.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.record != null) {
                this.record.rollback();
            }
        }
    }

    @Override
    public void setUpdateOrDeleteTable(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return;
        }
        if (this.updateTables == null) {
            this.updateTables = new ArrayList();
        }
        this.updateTables.add(name);
    }

    @Override
    public synchronized boolean isCreate() {
        return this.createFlag;
    }

    @Override
    public boolean isType() {
        return true;
    }

    @Override
    public ScriptContext getScriptContext() {
        return this.context;
    }

    @Override
    public ImageOp getImageOp() {
        return this.imageOp;
    }

    public MDbm getMDbm() {
        return this.mdbm;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public MetaJson getMeta(String model) throws Exception {
        this.checkCreate();
        DaoFactory factory = this.getDaoFactory();
        Dao dao = factory.getDao(this.record, model);
        if (dao == null) {
            throw new MaachangDaoException("\u5bfe\u8c61\u306eModel\u60c5\u5831[" + model + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return dao.getMeta();
    }

    @Override
    public HashMap<String, Object> getMetaByJson(String model) throws Exception {
        this.checkCreate();
        MetaJson meta = this.getMeta(model);
        return meta.getJson();
    }

    @Override
    public Long save(String model, HashMap<String, Object> args) throws Exception {
        this.checkCreate();
        DaoFactory factory = this.getDaoFactory();
        Dao dao = factory.getDao(this.record, model);
        if (!dao.save(this.record, args)) {
            return new Long(-1L);
        }
        Object ret = args.get("id");
        if (ret != null && ret instanceof String) {
            ret = new Long((String)ret);
        }
        return (Long)ret;
    }

    @Override
    public void update(String model, String where, ArrayList<Object> args) throws Exception {
        this.checkCreate();
        DaoFactory factory = this.getDaoFactory();
        Dao dao = factory.getDao(this.record, model);
        dao.update(this.record, where, args);
    }

    @Override
    public void remove(String model, ImageOp im, ArrayList<String> delJoins, Map<String, List<String>> srcJoin, String where, ArrayList<Object> args) throws Exception {
        this.checkCreate();
        DaoFactory factory = this.getDaoFactory();
        Dao dao = factory.getDao(this.record, model);
        dao.remove(this.record, im, delJoins, srcJoin, where, args);
    }

    @Override
    public void removeData(String model, ImageOp im, ArrayList<String> delJoins, Map<String, List<String>> srcJoin, HashMap<String, Object> args) throws Exception {
        this.checkCreate();
        DaoFactory factory = this.getDaoFactory();
        Dao dao = factory.getDao(this.record, model);
        dao.remove(this.record, im, delJoins, srcJoin, args);
    }

    @Override
    public List<Map<String, Object>> find(String model, Map<String, String> join, Map<String, List<String>> srcJoin, String where, ArrayList<Object> args) throws Exception {
        this.checkCreate();
        DaoFactory factory = this.getDaoFactory();
        Dao dao = factory.getDao(this.record, model);
        return dao.find(this.record, join, srcJoin, where, args);
    }

    @Override
    public List<Map<String, Object>> limit(String model, Map<String, String> join, Map<String, List<String>> srcJoin, int offset, int limit, String where, ArrayList<Object> args) throws Exception {
        this.checkCreate();
        DaoFactory factory = this.getDaoFactory();
        Dao dao = factory.getDao(this.record, model);
        return dao.limit(this.record, join, srcJoin, offset, limit, where, args);
    }

    @Override
    public List<Map<String, Object>> first(String model, Map<String, String> join, Map<String, List<String>> srcJoin, String where, ArrayList<Object> args) throws Exception {
        this.checkCreate();
        DaoFactory factory = this.getDaoFactory();
        Dao dao = factory.getDao(this.record, model);
        return dao.first(this.record, join, srcJoin, where, args);
    }

    @Override
    public int count(String model, String where, ArrayList<Object> args) throws Exception {
        this.checkCreate();
        DaoFactory factory = this.getDaoFactory();
        Dao dao = factory.getDao(this.record, model);
        return dao.count(this.record, where, args);
    }

    @Override
    public Object sql(String sql) throws Exception {
        return ExecutionDao.executionStatement((Record)this.record, (String)sql);
    }

    public int executionUpdate(String sql) throws Exception {
        this.checkCreate();
        return this.record.executeUpdate(sql);
    }

    public boolean isDebug() {
        if (this.record != null) {
            return this.record.isDebug();
        }
        return false;
    }

    private DaoFactory getDaoFactory() {
        return (DaoFactory)GlobalManager.getInstance().get("DAO_FACTORY");
    }

    private void checkCreate() throws Exception {
        if (!this.isCreate()) {
            throw new IOException("BaseModel\u306f\u751f\u6210\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }

    private void checkCommit() throws Exception {
        if (this.record == null) {
            throw new IOException("\u30ec\u30b3\u30fc\u30c9\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (!this.record.isUse()) {
            throw new IOException("\u30ec\u30b3\u30fc\u30c9\u51e6\u7406\u30a8\u30e9\u30fc");
        }
    }
}

