/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import org.maachang.util.StringUtil;

public class SrcScript {
    public static final String[] SPECIAL_SRC = new String[]{"<", ">"};
    public static final String[] SPECIAL_DEST = new String[]{"&lt;", "&gt;"};
    private String[] script = null;

    private SrcScript() {
    }

    public SrcScript(String script) throws Exception {
        if (script == null || (script = script.trim()).length() <= 0) {
            this.script = new String[0];
        } else {
            String line;
            ArrayList<String> scs = new ArrayList<String>();
            BufferedReader sr = new BufferedReader(new StringReader(script));
            int len = SPECIAL_SRC.length;
            while ((line = sr.readLine()) != null) {
                if (line.length() > 0) {
                    int i = 0;
                    while (i < len) {
                        line = StringUtil.changeString((String)line, (String)SPECIAL_SRC[i], (String)SPECIAL_DEST[i]);
                        ++i;
                    }
                }
                scs.add(line);
            }
            sr.close();
            if (scs.size() <= 0) {
                this.script = new String[0];
            } else {
                len = scs.size();
                this.script = new String[len];
                int i = 0;
                while (i < len) {
                    this.script[i] = (String)scs.get(i);
                    ++i;
                }
            }
        }
    }

    public String get(int line) {
        if (line <= 0 || line > this.script.length) {
            return null;
        }
        return this.script[line - 1];
    }

    public int lines() {
        return this.script.length;
    }

    public String toString() {
        if (this.script != null) {
            StringBuilder buf = new StringBuilder();
            int len = this.script.length;
            int i = 0;
            while (i < len) {
                buf.append(i).append(":").append(this.script[i]);
                ++i;
            }
            return buf.toString();
        }
        return "";
    }
}

