/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.cache.CacheTable;
import org.maachang.comet.httpd.engine.script.cache.CacheTableWrapper;
import org.maachang.comet.httpd.engine.script.dao.MasterCache;
import org.maachang.manager.GlobalManager;

public class CacheDefaultScript {
    private static final Log LOG = LogFactory.getLog(CacheDefaultScript.class);
    private static final String CACHE_TABLE_NAME = "default";
    protected static final String ENGINE_NAME = "js";
    private static final String[] LIST = new String[]{"org/maachang/comet/httpd/engine/script/js/default.js", "org/maachang/comet/httpd/engine/script/js/log.js", "org/maachang/comet/httpd/engine/script/js/exception.js", "org/maachang/comet/httpd/engine/script/js/io.js", "org/maachang/comet/httpd/engine/script/js/html.js", "org/maachang/comet/httpd/engine/script/js/validate.js", "org/maachang/comet/httpd/engine/script/js/tag.js", "org/maachang/comet/httpd/engine/script/js/master_cache.js", "org/maachang/comet/httpd/engine/script/js/record.js", "org/maachang/comet/httpd/engine/script/js/base_model.js", "org/maachang/comet/httpd/engine/script/js/image.js", "org/maachang/comet/httpd/engine/script/js/mdbm.js", "org/maachang/comet/httpd/engine/script/js/http_client.js", "org/maachang/comet/httpd/engine/script/js/mail.js", "org/maachang/comet/httpd/engine/script/js/template.js", "org/maachang/comet/httpd/engine/script/js/rpc.js", "org/maachang/comet/httpd/engine/script/js/utils.js", "org/maachang/comet/httpd/engine/script/js/mttml.js", "org/maachang/comet/httpd/engine/script/js/startup.js"};
    private static final String[] LIST_NAME = new String[]{"*base_script", "*log", "*exception", "*io", "*html", "*validate", "*tag", "*master_cache", "*record", "*base_model", "*image", "*mdbm", "*http_client", "*mail", "*template", "*rpc", "*utils", "*mttml", "*startup"};
    private static final String HEAD = "*";
    private final CacheTableWrapper wrapper = new CacheTableWrapper();
    private HashMap<String, SrcScript> srcScripts = null;
    private final Object sync = new Object();

    protected void finalize() throws Exception {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.wrapper.getCacheTable().clearAll();
            this.srcScripts = null;
        }
    }

    public CacheTableWrapper getCacheTableWrapper() {
        return this.wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheTableWrapper script() throws Exception {
        try {
            CacheTableWrapper ret = null;
            Object object = this.sync;
            synchronized (object) {
                if (!this.wrapper.getCacheTable().isParent(CACHE_TABLE_NAME)) {
                    this.loadScripts();
                }
                ret = this.wrapper;
            }
            return ret;
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrcScript getSrcScript(String path) {
        if (!this.isCache(path)) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.srcScripts != null) {
                return this.srcScripts.get(path);
            }
        }
        return null;
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.startsWith(HEAD);
    }

    private void loadScripts() throws Exception {
        int len = LIST.length;
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(ENGINE_NAME);
        CacheTable cacheTable = this.wrapper.getCacheTable();
        cacheTable.waitByStartUpdate();
        try {
            MasterCache masterCache = new MasterCache();
            Map shared = Collections.synchronizedMap(new HashMap());
            GlobalManager.getInstance().put("MASTER_DB_CACHE_MANAGER", (Object)masterCache);
            GlobalManager.getInstance().put("SHARED_MEMORY_MANAGER", shared);
            this.wrapper.setCacheAppend(true);
            Bindings bindings = new SimpleBindings(this.wrapper);
            bindings.put("_$script$context", (Object)null);
            bindings.put("_$$maachang_comet_manager", (Object)GlobalManager.getInstance());
            bindings.put("_$cachedb$params", (Object)masterCache);
            bindings.put("_$shared$params", (Object)shared);
            this.srcScripts = new HashMap();
            int i = 0;
            while (i < len) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">read[default] - " + LIST_NAME[i]));
                }
                String script = ScriptDef.getScriptByResource(LIST[i]);
                this.srcScripts.put(LIST_NAME[i], new SrcScript(script));
                engine.put("javax.script.filename", LIST_NAME[i]);
                engine.eval(script, bindings);
                ++i;
            }
            bindings = cacheTable.getBindings();
            cacheTable.putParent(CACHE_TABLE_NAME, bindings);
        }
        finally {
            this.wrapper.setCacheAppend(false);
            cacheTable.exitUpdate();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"** default-cache\u3092\u8aad\u307f\u8fbc\u307f");
        }
    }
}

