/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.maachang.comet.httpd.engine.script.cache.CacheTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheTableWrapper
implements Map<String, Object> {
    private Map<String, Bindings> manager = null;
    private CacheTable cacheTable = null;
    private volatile boolean cacheAppend = false;
    private final Object sync = new Object();

    public CacheTableWrapper() {
        this.manager = Collections.synchronizedMap(new HashMap());
        this.cacheTable = new CacheTable();
    }

    public CacheTableWrapper(CacheTable cacheTable) throws Exception {
        if (cacheTable == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.cacheTable = cacheTable;
    }

    public CacheTable getCacheTable() {
        this.cacheTable.waitUpdate();
        return this.cacheTable;
    }

    public void clearThread() {
        this.cacheTable.waitUpdate();
        this.manager.remove(Thread.currentThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheAppend(boolean mode) {
        Object object = this.sync;
        synchronized (object) {
            this.cacheAppend = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCacheAppend() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.cacheAppend;
        }
        return ret;
    }

    public Object[] getAllKey() {
        HashSet<String> keys = this.cacheTable.getAllKey();
        Bindings bin = this.getTable();
        if (bin != null && bin.size() > 0) {
            Object[] o = bin.keySet().toArray();
            int len = o.length;
            int i = 0;
            while (i < len) {
                keys.add((String)o[i]);
                ++i;
            }
        }
        return keys.toArray();
    }

    @Override
    public int size() {
        this.cacheTable.waitUpdate();
        if (this.isCacheAppend()) {
            return this.cacheTable.size();
        }
        return this.getTable().size() + this.cacheTable.size();
    }

    @Override
    public void clear() {
        this.cacheTable.waitUpdate();
        this.getTable().clear();
    }

    @Override
    public boolean isEmpty() {
        this.cacheTable.waitUpdate();
        if (this.isCacheAppend()) {
            return this.cacheTable.isEmpty();
        }
        if (!this.getTable().isEmpty()) {
            return this.cacheTable.isEmpty();
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        this.cacheTable.waitUpdate();
        if (this.isCacheAppend()) {
            return this.cacheTable.containsKey(key);
        }
        if (this.getTable().containsKey(key)) {
            return true;
        }
        return this.cacheTable.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.cacheTable.waitUpdate();
        if (this.isCacheAppend()) {
            return this.cacheTable.containsValue(value);
        }
        if (this.getTable().containsValue(value)) {
            return true;
        }
        return this.cacheTable.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        this.cacheTable.waitUpdate();
        if (this.isCacheAppend()) {
            return this.cacheTable.get(key);
        }
        Object o = this.getTable().get(key);
        if (o != null) {
            return o;
        }
        return this.cacheTable.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        this.cacheTable.waitUpdate();
        if (this.isCacheAppend()) {
            return this.cacheTable.put(key, value);
        }
        return this.getTable().put(key, value);
    }

    @Override
    public Object remove(Object key) {
        this.cacheTable.waitUpdate();
        return this.getTable().remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
    }

    @Override
    public Set<String> keySet() {
        return null;
    }

    @Override
    public Collection<Object> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }

    public boolean equals(Map<String, Object> o) {
        return false;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    private synchronized Bindings getTable() {
        String name = Thread.currentThread().getName();
        Bindings ret = this.manager.get(name);
        if (ret == null) {
            ret = new SimpleBindings();
            this.manager.put(name, ret);
        }
        return ret;
    }
}

