/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.js;

import org.maachang.comet.httpd.engine.script.js.JsDef;

public class ConvertTag {
    private static final String[] CONVERT = new String[]{"script", "object"};

    public static final boolean isTag(String string) {
        return ConvertTag.isTag(CONVERT, string);
    }

    public static final boolean isTag(String[] tags, String string) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return false;
        }
        if (tags == null || tags.length <= 0) {
            return false;
        }
        boolean execFlag = false;
        int len = tags.length;
        String lower = string.toLowerCase();
        int i = 0;
        while (i < len) {
            if (lower.indexOf(tags[i]) != -1) {
                execFlag = true;
                break;
            }
            ++i;
        }
        lower = null;
        if (!execFlag) {
            return false;
        }
        int p = 0;
        int[] pos;
        while ((pos = ConvertTag.getStartTagPos(string, p)) != null) {
            String name;
            int[] tagPos = ConvertTag.getTargetNamePos(string, pos);
            if (tagPos == null) {
                p = pos[1] + 1;
            }
            if (ConvertTag.isDirectTag(tags, name = string.substring(tagPos[0], tagPos[1]))) {
                return true;
            }
            p = pos[1] + 1;
        }
        return false;
    }

    public static final String convert(String string) {
        return ConvertTag.convert(CONVERT, string);
    }

    public static final String convert(String[] tags, String string) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return "";
        }
        if (tags == null || tags.length <= 0) {
            return string;
        }
        boolean execFlag = false;
        int len = tags.length;
        String lower = string.toLowerCase();
        int i = 0;
        while (i < len) {
            if (lower.indexOf(tags[i]) != -1) {
                execFlag = true;
                break;
            }
            ++i;
        }
        lower = null;
        if (!execFlag) {
            return string;
        }
        int p = 0;
        StringBuilder buf = new StringBuilder();
        while (true) {
            String name;
            int[] pos;
            if ((pos = ConvertTag.getStartTagPos(string, p)) == null) break;
            int[] tagPos = ConvertTag.getTargetNamePos(string, pos);
            if (tagPos == null) {
                buf.append(string.substring(p, pos[1] + 1));
                p = pos[1] + 1;
            }
            if (ConvertTag.isDirectTag(tags, name = string.substring(tagPos[0], tagPos[1]))) {
                buf.append(string.substring(p, pos[0]));
                p = pos[1] + 1;
                String s = string.substring(pos[0], pos[1] + 1);
                buf.append(JsDef.convertByViewHtml(false, s));
                continue;
            }
            buf.append(string.substring(p, pos[1] + 1));
            p = pos[1] + 1;
        }
        buf.append(string.substring(p));
        return buf.toString();
    }

    private static final boolean isDirectTag(String[] tags, String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return false;
        }
        name = name.toLowerCase();
        int len = tags.length;
        int i = 0;
        while (i < len) {
            if (tags[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final int[] getStartTagPos(String string, int pos) {
        int p = ConvertTag.getTargetPos(string, '<', pos);
        if (p == -1) {
            return null;
        }
        int p2 = ConvertTag.getEndTagPos(string, p);
        if (p2 == -1) {
            return null;
        }
        return new int[]{p, p2};
    }

    private static final int[] getTargetNamePos(String string, int[] pos) {
        if (pos == null) {
            return null;
        }
        int[] ret = null;
        int len = string.length();
        int mode = 0;
        int i = pos[0] + 1;
        while (i < len) {
            if (mode != 1 && i >= pos[1]) break;
            char c = string.charAt(i);
            if (mode == 0) {
                if (c != ' ' && c != '\u3000' && c != '\r' && c != '\n' && c != '\t' && c != '/') {
                    ret = new int[2];
                    ret[0] = i;
                    mode = 1;
                }
            } else if (!(mode != 1 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                ret[1] = i;
                mode = 2;
                break;
            }
            ++i;
        }
        if (mode == 2) {
            return ret;
        }
        return null;
    }

    private static final int getTargetPos(String string, char target, int pos) {
        int len = string.length();
        int n = -1;
        int i = pos;
        while (i < len) {
            char c;
            char c2 = string.charAt(i);
            if (c != '\uffffffff') {
                if (c2 == c) {
                    c = '\uffffffff';
                }
            } else if (c2 == '\'' || c2 == '\"') {
                c = c2 & 0xFFFF;
            } else if (c2 == target) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int getEndTagPos(String string, int pos) {
        return ConvertTag.getTargetPos(string, '>', pos);
    }
}

