/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.taglib;

import java.io.IOException;
import java.util.ArrayList;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.taglib.DefineTagLib;
import org.maachang.conf.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisTagLib {
    private static final String START_TAGLIB = "<$";
    private static final String END_TAGLIB = ">";
    private static final String START_PLIB = "${";
    private static final String END_PLIB = "}";
    private static final String START_PHLIB = "@{";
    private static final String END_PHLIB = "}";

    public static final String analysis(String string) throws Exception {
        string = AnalysisTagLib.tagLib(string);
        string = AnalysisTagLib.varLib(string);
        return AnalysisTagLib.varHtmlLib(string);
    }

    private static final String tagLib(String string) throws Exception {
        StringBuilder buf;
        block8: {
            int e;
            int p = 0;
            int b = 0;
            p = string.indexOf(START_TAGLIB);
            if (p <= -1) {
                return string;
            }
            buf = new StringBuilder();
            int[] outTagPos = new int[1];
            do {
                boolean parFlag;
                String tagName;
                int parCd;
                if ((parCd = AnalysisTagLib.parCode(tagName = AnalysisTagLib.getTagLibName(outTagPos, string, p))) != -1) {
                    e = AnalysisTagLib.indexToNotPar(string, END_TAGLIB, '(', ')', p);
                    if (e <= -1) {
                        buf.append(string.substring(b));
                        break block8;
                    }
                    parFlag = true;
                } else {
                    e = AnalysisTagLib.indexToNotCote(string, END_TAGLIB, p);
                    if (e <= -1) {
                        buf.append(string.substring(b));
                        break block8;
                    }
                    parFlag = false;
                }
                buf.append(string.substring(b, p));
                if (parFlag) {
                    AnalysisTagLib.tagLibToPar(buf, string, tagName, parCd, outTagPos[0], e);
                    continue;
                }
                Config conf = DefineTagLib.getInstance().getConfig(tagName);
                if (conf != null) {
                    AnalysisTagLib.tagLibToDef(buf, string, tagName, conf, outTagPos[0], e);
                    continue;
                }
                buf.append(string.substring(p, e + 1));
            } while ((p = string.indexOf(START_TAGLIB, b = e + 1)) > -1);
            buf.append(string.substring(b));
        }
        return buf.toString();
    }

    private static final String varLib(String string) throws Exception {
        StringBuilder buf;
        block3: {
            int e;
            int p = 0;
            int b = 0;
            p = string.indexOf(START_PLIB);
            if (p <= -1) {
                return string;
            }
            buf = new StringBuilder();
            do {
                if ((e = AnalysisTagLib.indexToNotCote(string, "}", p)) <= -1) {
                    buf.append(string.substring(b));
                    break block3;
                }
                buf.append(string.substring(b, p));
                buf.append("<%= ").append(AnalysisTagLib.cutEnter(string.substring(p + 2, e))).append(" %>");
            } while ((p = string.indexOf(START_PLIB, b = e + 1)) > -1);
            buf.append(string.substring(b));
        }
        return buf.toString();
    }

    private static final String varHtmlLib(String string) throws Exception {
        StringBuilder buf;
        block3: {
            int e;
            int p = 0;
            int b = 0;
            p = string.indexOf(START_PHLIB);
            if (p <= -1) {
                return string;
            }
            buf = new StringBuilder();
            do {
                if ((e = AnalysisTagLib.indexToNotCote(string, "}", p)) <= -1) {
                    buf.append(string.substring(b));
                    break block3;
                }
                buf.append(string.substring(b, p));
                buf.append("<%= $html(").append(AnalysisTagLib.cutEnter(string.substring(p + 2, e))).append(") %>");
            } while ((p = string.indexOf(START_PHLIB, b = e + 1)) > -1);
            buf.append(string.substring(b));
        }
        return buf.toString();
    }

    private static final int indexToNotCote(String base, String cc, int off) throws Exception {
        int len = base.length();
        int n = -1;
        char[] ck = cc.toCharArray();
        int cLen = ck.length;
        int bef = 0;
        int i = off;
        while (i < len) {
            char c;
            char c2 = base.charAt(i);
            if (c != '\uffffffff') {
                if (bef != 92 && c2 == c) {
                    c = '\uffffffff';
                }
            } else if (bef != 92 && (c2 == '\'' || c2 == '\"')) {
                c = c2;
            } else if (c2 == ck[0]) {
                boolean res = true;
                int j = 1;
                while (j < cLen) {
                    if (i + j >= len || ck[j] != base.charAt(i + j)) {
                        res = false;
                        break;
                    }
                    ++j;
                }
                if (res) {
                    return i;
                }
            }
            bef = c2;
            ++i;
        }
        return -1;
    }

    private static final int indexToNotPar(String base, String cc, char st, char ed, int off) throws Exception {
        int len = base.length();
        int par = -1;
        char[] ck = cc.toCharArray();
        int cLen = ck.length;
        int idx = 0;
        int i = off;
        while (i < len) {
            char c = base.charAt(i);
            if (par != -1) {
                if (c == ed) {
                    if (--idx <= 0) {
                        par = -1;
                    }
                } else if (c == st) {
                    ++idx;
                }
            } else if (c == st) {
                idx = 1;
                par = c;
            } else if (c == ck[0]) {
                boolean res = true;
                int j = 1;
                while (j < cLen) {
                    if (i + j >= len || ck[j] != base.charAt(i + j)) {
                        res = false;
                        break;
                    }
                    ++j;
                }
                if (res) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private static final String trimPlus(String string) {
        char c;
        int s = -1;
        int e = -1;
        int len = string.length();
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c != ' ' && c != '\u3000' && c != '\r' && c != '\n' && c != '\t') {
                s = i;
                break;
            }
            ++i;
        }
        if (s == -1) {
            return "";
        }
        i = len - 1;
        while (i >= 0) {
            c = string.charAt(i);
            if (c != ' ' && c != '\u3000' && c != '\r' && c != '\n' && c != '\t') {
                e = i;
                break;
            }
            --i;
        }
        return string.substring(s, e + 1);
    }

    private static final String cutEnter(String string) {
        if (string == null || (string = AnalysisTagLib.trimPlus(string)).length() <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int len = string.length();
        int n = -1;
        int i = 0;
        while (i < len) {
            char c;
            char c2 = string.charAt(i);
            if (c != '\uffffffff') {
                if (c == c2) {
                    c = '\uffffffff';
                }
            } else if (c2 == '\'' || c2 == '\"') {
                c = c2;
            }
            if (c2 == '\r' || c2 == '\n') {
                if (c == '\uffffffff') {
                    buf.append(" ");
                }
            } else {
                buf.append(c2);
            }
            ++i;
        }
        return buf.toString();
    }

    private static final String getTagLibName(int[] out, String string, int pos) throws Exception {
        boolean endFlag = false;
        int s = -1;
        int len = string.length();
        int i = pos + 2;
        while (i < len) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\u3000' && c != '\r' && c != '\n' && c != '\t') {
                if (c == '/') {
                    endFlag = true;
                } else {
                    s = i;
                    break;
                }
            }
            ++i;
        }
        if (s == -1) {
            throw new IOException("\u4e0d\u6b63\u306a\u30bf\u30b0\u6761\u4ef6\u304c\u5b58\u5728\u3057\u307e\u3059:pos=" + pos);
        }
        int p = -1;
        int i2 = s;
        while (i2 < len) {
            char c = string.charAt(i2);
            if (c == ' ' || c == '\u3000' || c == '\r' || c == '\n' || c == '\t' || c == '(' || c == '>') {
                p = i2;
                break;
            }
            ++i2;
        }
        if (p == -1) {
            throw new IOException("\u4e0d\u6b63\u306a\u30bf\u30b0\u6761\u4ef6\u304c\u5b58\u5728\u3057\u307e\u3059:pos=" + pos);
        }
        out[0] = p;
        if (endFlag) {
            return "/" + string.substring(s, p).toLowerCase();
        }
        return string.substring(s, p).toLowerCase();
    }

    private static final String cutTagAndTagName(boolean mode, String string, int p, int e) throws Exception {
        String s = string.substring(p, e);
        if (mode) {
            return AnalysisTagLib.trimPlus(s);
        }
        return AnalysisTagLib.cutEnter(s);
    }

    private static final int parCode(String tagName) {
        if ("if".equals(tagName)) {
            return 1;
        }
        if ("elseif".equals(tagName)) {
            return 2;
        }
        if ("for".equals(tagName)) {
            return 3;
        }
        if ("while".equals(tagName)) {
            return 4;
        }
        if ("switch".equals(tagName)) {
            return 5;
        }
        if ("else".equals(tagName)) {
            return 6;
        }
        if ("case".equals(tagName)) {
            return 7;
        }
        if ("/endif".equals(tagName) || "/for".equals(tagName) || "/while".equals(tagName) || "/switch".equals(tagName)) {
            return 8;
        }
        if ("/case".equals(tagName)) {
            return 9;
        }
        if ("default".equals(tagName)) {
            return 10;
        }
        if ("/default".equals(tagName)) {
            return 11;
        }
        return -1;
    }

    private static final void tagLibToPar(StringBuilder buf, String string, String tagName, int parCd, int p, int e) throws Exception {
        String inner = AnalysisTagLib.cutTagAndTagName(true, string, p, e);
        switch (parCd) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (!inner.startsWith("(") || !inner.endsWith(")")) {
                    throw new IOException("\u30bf\u30b0(" + tagName + ")\u306b\u5bfe\u3057\u3066\u4e0d\u6b63\u306a\u5185\u5bb9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059:" + inner);
                }
                buf.append("<% ");
                if (parCd == 1) {
                    buf.append("if ");
                }
                if (parCd == 2) {
                    buf.append("} else if ");
                }
                if (parCd == 3) {
                    buf.append("for ");
                }
                if (parCd == 4) {
                    buf.append("while ");
                }
                if (parCd == 5) {
                    buf.append("switch ");
                }
                buf.append(inner);
                buf.append(" { %>");
                break;
            }
            case 6: {
                buf.append("<% } else { %>");
                break;
            }
            case 7: {
                buf.append("<% case : ").append(inner).append(" %>");
                break;
            }
            case 8: {
                buf.append("<% } %>");
                break;
            }
            case 9: {
                buf.append("<% break ; %>");
                break;
            }
            case 10: {
                buf.append("<% default : %>");
                break;
            }
            case 11: {
                buf.append("<% break ; %>");
            }
        }
    }

    private static final int getTagLibArgsLength(Config conf, String tagName) {
        String[] keys = conf.getKeys(tagName);
        int len = keys.length;
        int ret = 0;
        int i = 0;
        while (i < len) {
            if (keys[i].startsWith("$")) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    private static final void tagLibToDef(StringBuilder buf, String string, String tagName, Config conf, int p, int e) throws Exception {
        boolean notPrint = conf.getBoolean(tagName, "notPrint", 0);
        int argsLen = AnalysisTagLib.getTagLibArgsLength(conf, tagName);
        if (argsLen <= 0) {
            if (notPrint) {
                buf.append("<% ");
            } else {
                buf.append("<%= ");
            }
            buf.append(conf.get(tagName, "function", 0)).append("() %>");
            return;
        }
        String inner = AnalysisTagLib.cutTagAndTagName(false, string, p, e);
        ArrayList<String> lst = new ArrayList<String>();
        AnalysisTagLib.cutElement(lst, inner);
        ArrayList<String> etc = null;
        if (conf.isKeys(tagName, "$etc")) {
            etc = new ArrayList<String>();
        }
        String[] args = new String[argsLen];
        int len = lst.size();
        int i = 0;
        while (i < len) {
            String key = lst.get(i).toLowerCase();
            String value = lst.get(i + 1);
            if (!"etc".equals(key)) {
                if (DefineTagLib.getInstance().isEvent(key)) {
                    if (etc != null) {
                        etc.add("Event." + key + "(" + value + ")");
                    }
                } else {
                    int n = conf.getInt(tagName, "$" + key, 0);
                    if (n <= -1) {
                        if (etc != null) {
                            if ((value.startsWith("\"") || value.startsWith("'")) && (value.endsWith("\"") || value.endsWith("'"))) {
                                char cote = value.startsWith("\"") ? (char)'\"' : '\'';
                                value = JsDef.convetByCote(true, cote + value.substring(1, value.length() - 1) + cote);
                            } else {
                                value = JsDef.convetByCote(true, "\"" + value + "\"");
                            }
                            String v = "\"" + key + "=" + value + "\"";
                            etc.add(v);
                        }
                    } else {
                        args[n - 1] = value;
                    }
                }
            }
            i += 2;
        }
        if (etc != null && etc.size() > 0) {
            len = etc.size();
            StringBuilder etcBuf = new StringBuilder();
            etcBuf.append("[ ");
            int i2 = 0;
            while (i2 < len) {
                if (i2 != 0) {
                    etcBuf.append(",");
                }
                etcBuf.append((String)etc.get(i2));
                ++i2;
            }
            etcBuf.append(" ]");
            args[conf.getInt((String)tagName, (String)"$etc", (int)0) - 1] = etcBuf.toString();
        }
        if (notPrint) {
            buf.append("<% ");
        } else {
            buf.append("<%= ");
        }
        buf.append(conf.get(tagName, "function", 0)).append("(");
        len = args.length;
        i = 0;
        while (i < len) {
            if (i != 0) {
                buf.append(",");
            }
            if (args[i] == null) {
                buf.append("null");
            } else {
                buf.append(args[i]);
            }
            ++i;
        }
        buf.append(") %>");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void cutElement(ArrayList<String> out, String string) throws Exception {
        int len = string.length();
        boolean state = false;
        int par = -1;
        int parCnt = 0;
        int cote = -1;
        int s = -1;
        int e = -1;
        int bf = -1;
        int i = 0;
        while (i < len) {
            block27: {
                int c;
                block24: {
                    block29: {
                        block28: {
                            block26: {
                                block25: {
                                    block23: {
                                        c = string.charAt(i);
                                        if (cote == -1) break block23;
                                        if (c == cote && bf != 92) {
                                            cote = -1;
                                        }
                                        break block24;
                                    }
                                    if (par == -1) break block25;
                                    if (c == 40) {
                                        ++parCnt;
                                    } else if (c == 41) {
                                        --parCnt;
                                    }
                                    if (parCnt == 0) {
                                        parCnt = 0;
                                        par = -1;
                                    }
                                    break block24;
                                }
                                if (c != 39 && c != 34) break block26;
                                if (s != -1) {
                                    throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]");
                                }
                                if (!state) {
                                    throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]");
                                }
                                if (bf == 92) {
                                    throw new IOException("\u4e0d\u6b63\u306a\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]");
                                }
                                cote = c;
                                s = i;
                                break block27;
                            }
                            if (c != 40) break block28;
                            if (s != -1) {
                                throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]");
                            }
                            if (!state) {
                                throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]");
                            }
                            par = c;
                            parCnt = 1;
                            s = i;
                            break block27;
                        }
                        if (c != 13 && c != 10 && c != 32 && c != 12288 && c != 9) break block29;
                        if (!state && s != -1 && e == -1) {
                            e = i;
                            break block24;
                        } else if (state && s != -1) {
                            out.add(string.substring(s, i));
                            state = false;
                            s = -1;
                            e = -1;
                        }
                        break block24;
                    }
                    if (c == 61) {
                        if (!state && s != -1) {
                            if (e == -1) {
                                e = i;
                            }
                            out.add(string.substring(s, e));
                            state = true;
                            s = -1;
                            e = -1;
                        }
                    } else if (s == -1) {
                        s = i;
                    } else if (e != -1) {
                        throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]");
                    }
                }
                bf = c & 0xFFFF;
            }
            ++i;
        }
        if (!state && s != -1) {
            throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]");
        }
        if (state && s != -1) {
            out.add(string.substring(s));
        }
    }
}

