/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import org.maachang.comet.net.HttpServer;
import org.maachang.comet.net.ssl.SslOption;

class NetSslServerImpl
implements HttpServer {
    private static final int DEFAULT_PORT = 3443;
    protected static final int MIN_LENGTH = 1;
    protected static final int MAX_LENGTH = 5000;
    private SslOption option = null;
    private ServerSocketChannel channel = null;

    private NetSslServerImpl() {
    }

    public NetSslServerImpl(SslOption option, int port, int backlog) throws Exception {
        this(option, null, port, backlog);
    }

    public NetSslServerImpl(SslOption option, InetAddress addr, int port, int backlog) throws Exception {
        if (option == null) {
            throw new IllegalArgumentException("SslOption\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (backlog <= 1) {
            backlog = 1;
        } else if (backlog > 5000) {
            backlog = 5000;
        }
        if (port <= 0 || port > 65535) {
            port = 3443;
        }
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.configureBlocking(false);
        ServerSocket soc = channel.socket();
        soc.setReuseAddress(true);
        if (addr == null) {
            soc.bind(new InetSocketAddress(port), backlog);
        } else {
            soc.bind(new InetSocketAddress(addr, port), backlog);
        }
        this.option = option;
        this.channel = channel;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.channel = null;
    }

    public ServerSocketChannel channel() {
        if (this.isClosed()) {
            return null;
        }
        return this.channel;
    }

    public Object option() {
        if (this.isClosed()) {
            return null;
        }
        return this.option;
    }

    public boolean isClosed() {
        boolean ret = false;
        try {
            if (this.channel == null || !this.channel.socket().isBound() || this.channel.socket().isClosed()) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }
}

