/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.maachang.comet.net.nio.NioElement;

class NioOutputStream
extends OutputStream {
    private static final int BUFFER_LENGTH = 1024;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private NioElement element = null;
    private ByteBuffer buffer = null;
    private int count = 0;

    private NioOutputStream() {
    }

    public NioOutputStream(NioElement element) {
        this.element = element;
        this.buffer = ByteBuffer.allocate(1024);
        this.buffer.clear();
        this.element.update();
        this.element.startWrite();
    }

    public synchronized void close() throws IOException {
        if (this.element != null && this.element.isUse()) {
            try {
                this.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.element.getWriteBuffer().append(EMPTY_BUFFER);
        }
        this.element = null;
        this.buffer = null;
        this.count = 0;
    }

    public synchronized void flush() throws IOException {
        if (this.element == null || !this.element.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.count > 0) {
            this.buffer.flip();
            this.element.getWriteBuffer().append(this.buffer);
            this.buffer = ByteBuffer.allocate(1024);
            this.buffer.clear();
            this.count = 0;
        }
        this.element.update();
    }

    public synchronized void write(int b) throws IOException {
        if (this.element == null || !this.element.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.count >= 1024) {
            this.flush();
        }
        this.buffer.put((byte)(b & 0xFF));
        ++this.count;
    }
}

